/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin;

import com.extendedae_plus.network.PickFromWirelessC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class PickFromWirelessMixin {
    @Shadow
    public LocalPlayer player;
    @Shadow
    public HitResult hitResult;

    @Inject(method={"pickBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void eap$pickFromAeWireless(CallbackInfo ci) {
        GameType type;
        if (this.player == null || this.hitResult == null || this.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        GameType gameType = type = Minecraft.getInstance().gameMode != null ? Minecraft.getInstance().gameMode.getPlayerMode() : null;
        if (type == null || type.isCreative()) {
            return;
        }
        BlockHitResult bhr = (BlockHitResult)this.hitResult;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            try {
                BlockState state = level.getBlockState(bhr.getBlockPos());
                if (state != null && !state.isAir()) {
                    int slot;
                    ItemStack picked = state.getBlock().getCloneItemStack(state, (HitResult)bhr, (LevelReader)level, bhr.getBlockPos(), (Player)this.player);
                    if (picked.isEmpty()) {
                        picked = state.getBlock().asItem().getDefaultInstance();
                    }
                    if (!picked.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)picked, (ItemStack)this.player.getMainHandItem()) && (slot = this.player.getInventory().findSlotMatchingItem(picked)) != -1) {
                        return;
                    }
                }
            }
            catch (Throwable t) {
                return;
            }
        }
        Vec3 loc = bhr.getLocation();
        PacketDistributor.sendToServer((CustomPacketPayload)new PickFromWirelessC2SPacket(bhr.getBlockPos(), bhr.getDirection(), loc), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ci.cancel();
    }
}

