/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.client.gui;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.StackWithBounds;
import appeng.client.gui.TextOverride;
import appeng.client.gui.implementations.PatternProviderScreen;
import appeng.client.gui.me.crafting.CraftingCPUScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.Text;
import appeng.client.gui.style.TextAlignment;
import appeng.menu.slot.AppEngSlot;
import com.extendedae_plus.api.IExPatternPage;
import com.extendedae_plus.content.ClientPatternHighlightStore;
import com.extendedae_plus.network.CraftingMonitorJumpC2SPacket;
import com.extendedae_plus.network.CraftingMonitorOpenProviderC2SPacket;
import com.extendedae_plus.util.GuiUtil;
import com.glodblock.github.extendedae.client.gui.GuiExPatternProvider;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AEBaseScreen.class}, remap=false)
public abstract class AEBaseScreenMixin {
    @Unique
    private static int eap$getIntField(Object self, String name, int def) {
        for (Class<?> c = self.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(name);
                f.setAccessible(true);
                Object v = f.get(self);
                if (!(v instanceof Integer)) continue;
                Integer i = (Integer)v;
                return i;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return def;
    }

    @Unique
    private static Font eap$getFont(Object self) {
        for (Class<?> c = self.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField("font");
                f.setAccessible(true);
                Object v = f.get(self);
                if (!(v instanceof Font)) continue;
                Font font = (Font)v;
                return font;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Minecraft.getInstance().font;
    }

    @Unique
    private ScreenStyle eap$getStyle(Object self) {
        try {
            Field f = self.getClass().getDeclaredField("style");
            f.setAccessible(true);
            Object v = f.get(self);
            if (v instanceof ScreenStyle) {
                ScreenStyle s = (ScreenStyle)v;
                return s;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void eap$craftingCpuShiftLeftClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        AEBaseScreenMixin self = this;
        if (!(self instanceof CraftingCPUScreen)) {
            return;
        }
        CraftingCPUScreen screen = (CraftingCPUScreen)self;
        if (button != 0 || !Screen.hasShiftDown()) {
            return;
        }
        try {
            StackWithBounds hovered = screen.getStackUnderMouse(mouseX, mouseY);
            if (hovered == null || hovered.stack() == null) {
                return;
            }
            AEKey key = hovered.stack().what();
            if (key == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new CraftingMonitorJumpC2SPacket(key), (CustomPacketPayload[])new CustomPacketPayload[0]);
            cir.setReturnValue((Object)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void eap$craftingCpuShiftRightClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        AEBaseScreenMixin self = this;
        if (!(self instanceof CraftingCPUScreen)) {
            return;
        }
        CraftingCPUScreen screen = (CraftingCPUScreen)self;
        if (button != 1 || !Screen.hasShiftDown()) {
            return;
        }
        try {
            StackWithBounds hovered = screen.getStackUnderMouse(mouseX, mouseY);
            if (hovered == null || hovered.stack() == null) {
                return;
            }
            AEKey key = hovered.stack().what();
            if (key == null) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new CraftingMonitorOpenProviderC2SPacket(key), (CustomPacketPayload[])new CustomPacketPayload[0]);
            cir.setReturnValue((Object)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(method={"renderSlot"}, at={@At(value="TAIL")}, remap=false)
    private void eap$renderSlotAmounts(GuiGraphics guiGraphics, Slot s, CallbackInfo ci) {
        block10: {
            AEBaseScreenMixin self = this;
            if (!(s instanceof AppEngSlot)) {
                return;
            }
            AppEngSlot appEngSlot = (AppEngSlot)s;
            if (!appEngSlot.isActive() || !appEngSlot.isSlotEnabled()) {
                return;
            }
            ItemStack itemStack = appEngSlot.getItem();
            if (itemStack.isEmpty()) {
                return;
            }
            String amountText = GuiUtil.getPatternOutputText(itemStack);
            if (amountText.isEmpty()) {
                return;
            }
            Font font = AEBaseScreenMixin.eap$getFont(self);
            GuiUtil.drawAmountText(guiGraphics, font, amountText, appEngSlot.x, appEngSlot.y, 0.6f);
            try {
                IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)itemStack, (Level)Minecraft.getInstance().level);
                try {
                    AEKey key;
                    if (details == null || details.getOutputs() == null || details.getOutputs().isEmpty() || (key = ((GenericStack)details.getOutputs().get(0)).what()) == null || !ClientPatternHighlightStore.hasHighlight(key)) break block10;
                    try {
                        GuiUtil.drawSlotRainbowHighlight(guiGraphics, s.x, s.y);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Inject(method={"drawText"}, at={@At(value="TAIL")}, remap=false)
    private void eap$appendPageAfterPatternsLabel(GuiGraphics guiGraphics, Text text, @Nullable TextOverride override, CallbackInfo ci) {
        AEBaseScreenMixin self = this;
        if (!(self instanceof GuiExPatternProvider)) {
            return;
        }
        try {
            String s;
            String label;
            TranslatableContents tc;
            String key;
            Component content = text.getText();
            if (override != null && override.getContent() != null) {
                content = override.getContent().copy().withStyle(content.getStyle());
            }
            int imageWidth = AEBaseScreenMixin.eap$getIntField(self, "imageWidth", 0);
            int imageHeight = AEBaseScreenMixin.eap$getIntField(self, "imageHeight", 0);
            Rect2i bounds = new Rect2i(0, 0, imageWidth, imageHeight);
            Point pos = text.getPosition().resolve(bounds);
            float scale = text.getScale();
            Font font = AEBaseScreenMixin.eap$getFont(self);
            FormattedCharSequence contentLine = text.getMaxWidth() <= 0 ? content.getVisualOrderText() : (FormattedCharSequence)font.split((FormattedText)content, text.getMaxWidth()).get(0);
            int lineWidth = font.width(contentLine);
            int x = pos.getX();
            int y = pos.getY();
            TextAlignment align = text.getAlign();
            if (align == TextAlignment.CENTER) {
                textPx = Math.round((float)lineWidth * scale);
                x -= textPx / 2;
            } else if (align == TextAlignment.RIGHT) {
                textPx = Math.round((float)lineWidth * scale);
                x -= textPx;
            }
            boolean isPatterns = false;
            ComponentContents contents = content.getContents();
            if (contents instanceof TranslatableContents && (key = (tc = (TranslatableContents)contents).getKey()) != null && key.endsWith(".patterns")) {
                isPatterns = true;
            }
            if (!isPatterns && (label = content.getString()) != null) {
                if (label.equals(Component.translatable((String)"gui.pattern_provider.patterns").getString())) {
                    isPatterns = true;
                } else if (label.equals(Component.translatable((String)"gui.extendedae.patterns").getString())) {
                    isPatterns = true;
                } else if (label.equals(Component.translatable((String)"gui.ae2.patterns").getString())) {
                    isPatterns = true;
                }
            }
            if (!isPatterns && (s = content.getString()) != null && ("\u6837\u677f".equals(s) || s.contains("\u6837\u677f") && y >= 14)) {
                isPatterns = true;
            }
            if (!isPatterns) {
                return;
            }
            int cur = 1;
            int max = 1;
            if (self instanceof IExPatternPage) {
                IExPatternPage accessor = (IExPatternPage)((Object)self);
                cur = Math.max(0, accessor.eap$getCurrentPage()) + 1;
            }
            try {
                Field fMax = self.getClass().getDeclaredField("eap$maxPageLocal");
                fMax.setAccessible(true);
                Object v = fMax.get(self);
                if (v instanceof Integer) {
                    Integer i = (Integer)v;
                    max = Math.max(1, i);
                }
            }
            catch (Throwable fMax) {
                // empty catch block
            }
            String pageText = "\u7b2c" + cur + "\u9875/" + max + "\u9875";
            ScreenStyle style = this.eap$getStyle(self);
            int color = -1;
            if (style != null) {
                try {
                    color = style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            int padding = 4;
            if (scale == 1.0f) {
                guiGraphics.drawString(font, pageText, x + lineWidth + padding, y, color, false);
            } else {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)x, (float)y, 1.0f);
                guiGraphics.pose().scale(scale, scale, 1.0f);
                guiGraphics.drawString(font, pageText, lineWidth + padding, 0, color, false);
                guiGraphics.pose().popPose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Shadow
    protected void setTextContent(String id, Component content) {
    }

    @Inject(method={"updateBeforeRender"}, at={@At(value="RETURN")}, remap=false)
    private void onUpdateBeforeRender(CallbackInfo ci) {
        try {
            PatternProviderScreen screen;
            Component t;
            AEBaseScreen self = (AEBaseScreen)this;
            if (self instanceof PatternProviderScreen && (t = (screen = (PatternProviderScreen)self).getTitle()) != null && !t.getString().isEmpty()) {
                this.setTextContent("dialog_title", t);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

