/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.compat;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.crafting.execution.CraftingCpuLogic;
import appeng.crafting.execution.ExecutingCraftingJob;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import com.extendedae_plus.ae.wireless.IWirelessEndpoint;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.ae.wireless.endpoint.GenericNodeEndpointImpl;
import com.extendedae_plus.api.bridge.CompatUpgradeProvider;
import com.extendedae_plus.api.bridge.InterfaceWirelessLinkBridge;
import com.extendedae_plus.api.bridge.PatternProviderLogicUpgradeCompatBridge;
import com.extendedae_plus.compat.PatternProviderLogicVirtualCompatBridge;
import com.extendedae_plus.compat.UpgradeSlotCompat;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.items.materials.ChannelCardItem;
import com.extendedae_plus.mixin.ae2.accessor.CraftingCpuLogicAccessor;
import com.extendedae_plus.mixin.ae2.accessor.ExecutingCraftingJobAccessor;
import com.extendedae_plus.mixin.ae2.accessor.ExecutingCraftingJobTaskProgressAccessor;
import com.extendedae_plus.util.ExtendedAELogger;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternProviderLogic.class}, priority=900, remap=false)
public abstract class PatternProviderLogicCompatMixin
implements CompatUpgradeProvider,
InterfaceWirelessLinkBridge,
PatternProviderLogicVirtualCompatBridge,
PatternProviderLogicUpgradeCompatBridge {
    @Unique
    private IUpgradeInventory eap$compatUpgrades = UpgradeInventories.empty();
    @Unique
    private WirelessSlaveLink eap$compatLink;
    @Unique
    private long eap$compatLastChannel = -1L;
    @Unique
    private UUID eap$compatLastOwner;
    @Unique
    private boolean eap$compatClientConnected = false;
    @Unique
    private boolean eap$compatHasInitialized = false;
    @Unique
    private boolean eap$compatVirtualCraftingEnabled = false;
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Final
    @Shadow
    private IActionSource actionSource;

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void eap$compatInit(IManagedGridNode mainNode, PatternProviderLogicHost host, int size, CallbackInfo ci) {
        try {
            this.eap$compatUpgrades = UpgradeSlotCompat.shouldEnableUpgradeSlots() ? UpgradeInventories.forMachine((ItemLike)host.getTerminalIcon().getItem(), (int)2, this::eap$compatOnUpgradesChanged) : UpgradeInventories.empty();
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u521d\u59cb\u5316\u517c\u5bb9\u5347\u7ea7\u69fd\u5931\u8d25", t);
        }
    }

    @Unique
    private void eap$compatOnUpgradesChanged() {
        try {
            this.host.saveChanges();
            this.eap$compatLastChannel = -1L;
            this.eap$compatLastOwner = null;
            this.eap$compatHasInitialized = false;
            this.eap$compatInitializeChannelLink();
            this.eap$compatSyncVirtualCraftingState();
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u517c\u5bb9\u5347\u7ea7\u53d8\u66f4\u5904\u7406\u5931\u8d25", t);
        }
    }

    @Override
    public void eap$onCompatUpgradesChangedHook() {
        this.eap$compatOnUpgradesChanged();
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void eap$compatWrite(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                this.eap$compatUpgrades.writeToNBT(tag, "compat_upgrades", registries);
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u4fdd\u5b58\u517c\u5bb9\u5347\u7ea7\u5931\u8d25", t);
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$compatRead(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                this.eap$compatUpgrades.readFromNBT(tag, "compat_upgrades", registries);
            }
            this.eap$compatLastChannel = -1L;
            this.eap$compatHasInitialized = false;
            this.eap$compatInitializeChannelLink();
            this.eap$compatSyncVirtualCraftingState();
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u8bfb\u53d6\u517c\u5bb9\u5347\u7ea7\u5931\u8d25", t);
        }
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void eap$compatDrops(List<ItemStack> drops, CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                for (ItemStack s : this.eap$compatUpgrades) {
                    if (s.isEmpty()) continue;
                    drops.add(s);
                }
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u6389\u843d\u517c\u5bb9\u5347\u7ea7\u5931\u8d25", t);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void eap$compatClear(CallbackInfo ci) {
        try {
            if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                this.eap$compatUpgrades.clear();
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u6e05\u7406\u517c\u5bb9\u5347\u7ea7\u5931\u8d25", t);
        }
    }

    @Inject(method={"onMainNodeStateChanged"}, at={@At(value="TAIL")})
    private void eap$compatOnNodeChange(CallbackInfo ci) {
        try {
            this.eap$compatLastChannel = -1L;
            this.eap$compatLastOwner = null;
            this.eap$compatHasInitialized = false;
            this.eap$compatInitializeChannelLink();
            this.mainNode.ifPresent((grid, node) -> {
                try {
                    grid.getTickManager().wakeDevice(node);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u4e3b\u8282\u70b9\u72b6\u6001\u53d8\u66f4\u5904\u7406\u5931\u8d25", t);
        }
    }

    @Override
    public void eap$updateWirelessLink() {
        if (this.eap$compatLink != null) {
            this.eap$compatLink.updateStatus();
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (this.host.getBlockEntity() != null && this.host.getBlockEntity().getLevel() != null && this.host.getBlockEntity().getLevel().isClientSide) {
            return this.eap$compatClientConnected;
        }
        return this.eap$compatLink != null && this.eap$compatLink.isConnected();
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        this.eap$compatClientConnected = connected;
    }

    @Override
    public boolean eap$hasTickInitialized() {
        return this.eap$compatHasInitialized;
    }

    @Override
    public void eap$setTickInitialized(boolean initialized) {
        this.eap$compatHasInitialized = initialized;
    }

    @Override
    public void eap$handleDelayedInit() {
        if (!this.eap$compatHasInitialized) {
            this.eap$compatInitializeChannelLink();
        }
    }

    @Override
    public boolean eap$shouldKeepTicking() {
        try {
            if (this.host.getBlockEntity() == null || this.host.getBlockEntity().getLevel() == null || this.host.getBlockEntity().getLevel().isClientSide) {
                return false;
            }
            if (!this.eap$compatHasInitialized) {
                return true;
            }
            IUpgradeInventory upgrades = this.eap$compatGetEffectiveUpgrades();
            if (upgrades != null && this.eap$hasChannelCard(upgrades) && (this.eap$compatLink == null || !this.eap$compatLink.isConnected())) {
                return true;
            }
            if (this.eap$compatLink != null && !this.eap$compatLink.isConnected()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Unique
    private void eap$compatInitializeChannelLink() {
        try {
            boolean sameOwner;
            if (this.host.getBlockEntity() != null && this.host.getBlockEntity().getLevel() != null && this.host.getBlockEntity().getLevel().isClientSide) {
                return;
            }
            if (this.eap$compatHasInitialized) {
                return;
            }
            if (this.mainNode == null || this.mainNode.getNode() == null) {
                return;
            }
            long channel = 0L;
            boolean found = false;
            UUID owner = null;
            Object upgrades = null;
            if (!UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                try {
                    upgrades = this.eap$getAppliedFluxUpgrades();
                    if (upgrades == null) {
                        ExtendedAELogger.LOGGER.warn("[\u6837\u677f\u4f9b\u5e94\u5668] \u65e0\u6cd5\u83b7\u53d6 appflux \u5347\u7ea7\u69fd\uff0c\u56de\u9000\u5230\u517c\u5bb9\u69fd");
                        upgrades = this.eap$compatUpgrades;
                    }
                }
                catch (Throwable t) {
                    ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u83b7\u53d6 appflux \u5347\u7ea7\u69fd\u5931\u8d25\uff0c\u56de\u9000\u5230\u517c\u5bb9\u69fd", t);
                    upgrades = this.eap$compatUpgrades;
                }
            } else {
                upgrades = this.eap$compatUpgrades;
            }
            if (upgrades == null || !this.eap$hasChannelCard((IUpgradeInventory)upgrades)) {
                if (UpgradeSlotCompat.shouldEnableUpgradeSlots()) {
                    try {
                        IUpgradeInventory backupUpgrades = this.eap$getAppliedFluxUpgrades();
                        if (backupUpgrades != null && this.eap$hasChannelCard(backupUpgrades)) {
                            upgrades = backupUpgrades;
                        }
                    }
                    catch (Throwable backupUpgrades) {}
                } else if (this.eap$compatUpgrades != null && this.eap$hasChannelCard(this.eap$compatUpgrades)) {
                    upgrades = this.eap$compatUpgrades;
                }
            }
            if (upgrades != null) {
                for (ItemStack stack : upgrades) {
                    if (stack.isEmpty() || stack.getItem() != ModItems.CHANNEL_CARD.get()) continue;
                    channel = ChannelCardItem.getChannel(stack);
                    owner = ChannelCardItem.getOwnerUUID(stack);
                    if (owner == null) {
                        owner = this.eap$getFallbackOwner();
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                this.eap$compatSyncVirtualCraftingState();
                if (this.eap$compatLink != null) {
                    this.eap$compatLink.setPlacerId(null);
                    this.eap$compatLink.setFrequency(0L);
                    this.eap$compatLink.updateStatus();
                }
                this.eap$compatLastChannel = 0L;
                this.eap$compatLastOwner = null;
                this.eap$compatHasInitialized = true;
                try {
                    this.host.saveChanges();
                }
                catch (Throwable backupUpgrades) {
                    // empty catch block
                }
                this.mainNode.ifPresent((grid, node) -> {
                    try {
                        grid.getTickManager().wakeDevice(node);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        for (IGridConnection gc : node.getConnections()) {
                            IGridNode other;
                            if (gc == null || gc.isInWorld() || (other = gc.getOtherSide(node)) == null || !(other.getOwner() instanceof IWirelessEndpoint)) continue;
                            gc.destroy();
                            try {
                                grid.getTickManager().wakeDevice(node);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                if (other.getGrid() == null) continue;
                                other.getGrid().getTickManager().wakeDevice(other);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                return;
            }
            boolean bl = sameOwner = this.eap$compatLastOwner == null && owner == null || this.eap$compatLastOwner != null && this.eap$compatLastOwner.equals(owner);
            if (this.eap$compatLink != null && this.eap$compatLastChannel == channel && sameOwner) {
                if (this.eap$compatLink.isConnected()) {
                    this.eap$compatHasInitialized = true;
                }
                return;
            }
            if (this.eap$compatLink == null) {
                GenericNodeEndpointImpl endpoint = new GenericNodeEndpointImpl(() -> this.host.getBlockEntity(), () -> this.mainNode.getNode());
                this.eap$compatLink = new WirelessSlaveLink(endpoint);
            }
            this.eap$compatLink.setPlacerId(owner);
            this.eap$compatLink.setFrequency(channel);
            this.eap$compatLink.updateStatus();
            this.eap$compatLastChannel = channel;
            this.eap$compatLastOwner = owner;
            try {
                this.host.saveChanges();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.mainNode.ifPresent((grid, node) -> {
                try {
                    grid.getTickManager().wakeDevice(node);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            if (this.eap$compatLink.isConnected()) {
                this.eap$compatHasInitialized = true;
            } else {
                this.eap$compatHasInitialized = false;
                this.mainNode.ifPresent((grid, node) -> {
                    try {
                        grid.getTickManager().wakeDevice(node);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            this.eap$compatSyncVirtualCraftingState();
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u521d\u59cb\u5316\u9891\u9053\u94fe\u63a5\u5931\u8d25", t);
        }
    }

    @Unique
    private UUID eap$getFallbackOwner() {
        if (this.mainNode != null && this.mainNode.getNode() != null) {
            return this.mainNode.getNode().getOwningPlayerProfileId();
        }
        return null;
    }

    @Unique
    private boolean eap$hasChannelCard(IUpgradeInventory inventory) {
        return this.eap$compatInventoryContains(inventory, (Item)ModItems.CHANNEL_CARD.get());
    }

    @Unique
    private IUpgradeInventory eap$getAppliedFluxUpgrades() {
        try {
            IUpgradeableObject upgradeableObject;
            IUpgradeInventory upgrades;
            PatternProviderLogicCompatMixin patternProviderLogicCompatMixin = this;
            if (patternProviderLogicCompatMixin instanceof IUpgradeableObject && (upgrades = (upgradeableObject = (IUpgradeableObject)patternProviderLogicCompatMixin).getUpgrades()) != null && upgrades != this.eap$compatUpgrades) {
                return upgrades;
            }
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u83b7\u53d6AppliedFlux\u5347\u7ea7\u69fd\u65f6\u51fa\u9519", t);
        }
        return null;
    }

    @Override
    public IUpgradeInventory eap$getCompatUpgrades() {
        return this.eap$compatUpgrades != null ? this.eap$compatUpgrades : UpgradeInventories.empty();
    }

    @Inject(method={"pushPattern"}, at={@At(value="RETURN")}, cancellable=true)
    private void eap$compatAfterPushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValueZ()) {
            this.eap$compatTryVirtualCompletion(patternDetails);
        }
    }

    @Unique
    private void eap$compatTryVirtualCompletion(IPatternDetails patternDetails) {
        if (!this.eap$compatVirtualCraftingEnabled) {
            return;
        }
        IGridNode node = this.mainNode.getNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return;
        }
        ICraftingService craftingService = grid.getCraftingService();
        if (craftingService == null) {
            return;
        }
        for (ICraftingCPU cpu : craftingService.getCpus()) {
            CraftingCpuLogicAccessor logicAccessor;
            ExecutingCraftingJob job;
            if (!cpu.isBusy() || !(cpu instanceof CraftingCPUCluster)) continue;
            CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
            CraftingCpuLogic craftingCpuLogic = cluster.craftingLogic;
            if (!(craftingCpuLogic instanceof CraftingCpuLogicAccessor) || !((job = (logicAccessor = (CraftingCpuLogicAccessor)craftingCpuLogic).eap$getJob()) instanceof ExecutingCraftingJobAccessor)) continue;
            ExecutingCraftingJobAccessor accessor = (ExecutingCraftingJobAccessor)job;
            Map<IPatternDetails, ExecutingCraftingJobTaskProgressAccessor> tasks = accessor.eap$getTasks();
            ExecutingCraftingJobTaskProgressAccessor progress = tasks.get(patternDetails);
            if (progress == null && patternDetails != null) {
                AEItemKey patternDefinition = patternDetails.getDefinition();
                for (Map.Entry<IPatternDetails, ExecutingCraftingJobTaskProgressAccessor> entry : tasks.entrySet()) {
                    AEItemKey taskDefinition;
                    IPatternDetails taskPattern = entry.getKey();
                    if (taskPattern == patternDetails) {
                        progress = entry.getValue();
                        break;
                    }
                    if (taskPattern == null || patternDefinition == null || (taskDefinition = taskPattern.getDefinition()) == null || !taskDefinition.equals((Object)patternDefinition)) continue;
                    progress = entry.getValue();
                    break;
                }
            }
            if (progress == null || progress.eap$getValue() > 1L) continue;
            cluster.cancelJob();
            break;
        }
    }

    @Override
    public boolean eap$compatIsVirtualCraftingEnabled() {
        return this.eap$compatVirtualCraftingEnabled;
    }

    @Override
    public IManagedGridNode eap$compatGetMainNode() {
        return this.mainNode;
    }

    @Unique
    private void eap$compatSyncVirtualCraftingState() {
        try {
            IUpgradeInventory upgrades = this.eap$compatGetEffectiveUpgrades();
            this.eap$compatVirtualCraftingEnabled = this.eap$compatInventoryContains(upgrades, (Item)ModItems.VIRTUAL_CRAFTING_CARD.get());
        }
        catch (Throwable t) {
            ExtendedAELogger.LOGGER.error("[\u6837\u677f\u4f9b\u5e94\u5668] \u540c\u6b65\u865a\u62df\u5408\u6210\u5361\u72b6\u6001\u5931\u8d25", t);
        }
    }

    @Unique
    private IUpgradeInventory eap$compatGetEffectiveUpgrades() {
        IUpgradeInventory upgrades = UpgradeSlotCompat.shouldEnableUpgradeSlots() ? this.eap$compatUpgrades : this.eap$getAppliedFluxUpgrades();
        if (upgrades == null || upgrades == UpgradeInventories.empty()) {
            if (upgrades != this.eap$compatUpgrades && this.eap$compatUpgrades != null) {
                upgrades = this.eap$compatUpgrades;
            } else {
                IUpgradeInventory fallback = this.eap$getAppliedFluxUpgrades();
                if (fallback != null) {
                    upgrades = fallback;
                }
            }
        }
        return upgrades;
    }

    @Unique
    private boolean eap$compatInventoryContains(IUpgradeInventory inventory, Item item) {
        if (inventory == null) {
            return false;
        }
        for (ItemStack stack : inventory) {
            if (stack.isEmpty() || stack.getItem() != item) continue;
            return true;
        }
        return false;
    }
}

