/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.helpers;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IManagedGridNode;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.IConfigManager;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.helpers.patternprovider.PatternProviderTarget;
import appeng.util.ConfigManager;
import com.extendedae_plus.api.config.EAPSettings;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderLogic.class}, remap=false)
public class PatternProviderLogicAdvancedMixin {
    @Shadow
    @Final
    private IConfigManager configManager;

    @Shadow
    public IConfigManager getConfigManager() {
        throw new AssertionError();
    }

    @Shadow
    public boolean isBlocking() {
        throw new AssertionError();
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void onInitTail(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        ConfigManager configManager = (ConfigManager)this.getConfigManager();
        configManager.registerSetting(EAPSettings.ADVANCED_BLOCKING, (Enum)YesNo.NO);
    }

    @Redirect(method={"pushPattern"}, at=@At(value="INVOKE", target="Lappeng/helpers/patternprovider/PatternProviderTarget;containsPatternInput(Ljava/util/Set;)Z"))
    private boolean eap$redirectBlockingContains(PatternProviderTarget adapter, Set<AEKey> patternInputs, IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!this.isBlocking()) {
            return adapter.containsPatternInput(patternInputs);
        }
        if (this.configManager.getSetting(EAPSettings.ADVANCED_BLOCKING) == YesNo.YES && this.eap$targetFullyMatchesPatternInputs(adapter, patternDetails)) {
            return false;
        }
        return adapter.containsPatternInput(patternInputs);
    }

    @Unique
    private boolean eap$targetFullyMatchesPatternInputs(PatternProviderTarget adapter, IPatternDetails patternDetails) {
        for (IPatternDetails.IInput in : patternDetails.getInputs()) {
            boolean slotMatched = false;
            for (GenericStack candidate : in.getPossibleInputs()) {
                AEKey key = candidate.what().dropSecondary();
                if (!adapter.containsPatternInput(Collections.singleton(key))) continue;
                slotMatched = true;
                break;
            }
            if (slotMatched) continue;
            return false;
        }
        return true;
    }

    @Inject(method={"configChanged"}, at={@At(value="HEAD")})
    private void eap$onConfigChanged(IConfigManager manager, Setting<?> setting, CallbackInfo ci) {
        if (setting == EAPSettings.ADVANCED_BLOCKING && manager.getSetting(EAPSettings.ADVANCED_BLOCKING) == YesNo.YES) {
            manager.putSetting(Settings.BLOCKING_MODE, (Enum)YesNo.YES);
        }
        if (setting == Settings.BLOCKING_MODE && manager.getSetting(Settings.BLOCKING_MODE) == YesNo.NO) {
            manager.putSetting(EAPSettings.ADVANCED_BLOCKING, (Enum)YesNo.NO);
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$readSmartDoublingFromNbt(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        if (tag.contains("epp_advanced_blocking")) {
            this.configManager.putSetting(EAPSettings.ADVANCED_BLOCKING, (Enum)(tag.getBoolean("epp_advanced_blocking") ? YesNo.YES : YesNo.NO));
            tag.remove("epp_advanced_blocking");
        }
    }
}

