/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.items.materials.ChannelCardItem;
import com.extendedae_plus.util.wireless.WirelessTeamUtil;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ChannelCardBindPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ChannelCardBindPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"channel_card_bind"));
    public static final StreamCodec<FriendlyByteBuf, ChannelCardBindPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> buf.writeEnum((Enum)pkt.hand), buf -> new ChannelCardBindPacket((InteractionHand)buf.readEnum(InteractionHand.class)));
    private final InteractionHand hand;

    public ChannelCardBindPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public static void handle(ChannelCardBindPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ItemStack stack = player.getItemInHand(msg.hand);
            if (stack.getItem() != ModItems.CHANNEL_CARD.get()) {
                return;
            }
            ServerLevel level = player.serverLevel();
            UUID currentOwner = ChannelCardItem.getOwnerUUID(stack);
            if (currentOwner != null) {
                ChannelCardItem.clearOwner(stack);
                player.displayClientMessage((Component)Component.translatable((String)"item.extendedae_plus.channel_card.owner.cleared"), true);
            } else {
                UUID playerUUID = player.getUUID();
                ChannelCardItem.setOwnerUUID(stack, playerUUID);
                Component teamName = WirelessTeamUtil.getNetworkOwnerName(level, playerUUID);
                ChannelCardItem.setTeamName(stack, teamName.getString());
                player.displayClientMessage((Component)Component.translatable((String)"item.extendedae_plus.channel_card.owner.bound", (Object[])new Object[]{teamName}), true);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

