/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.service.CraftingService;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftingCPUMenu;
import appeng.parts.AEBasePart;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderLogicAccessor;
import com.extendedae_plus.network.SetPatternHighlightS2CPacket;
import com.extendedae_plus.network.SetProviderPageS2CPacket;
import com.extendedae_plus.util.PatternProviderDataUtil;
import com.glodblock.github.extendedae.client.render.EAEHighlightHandler;
import com.glodblock.github.extendedae.util.FCClientUtil;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CraftingMonitorOpenProviderC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<CraftingMonitorOpenProviderC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"crafting_monitor_open_provider"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingMonitorOpenProviderC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> AEKey.writeKey((RegistryFriendlyByteBuf)buf, (AEKey)pkt.what), buf -> new CraftingMonitorOpenProviderC2SPacket(AEKey.readKey((RegistryFriendlyByteBuf)buf)));
    private final AEKey what;

    public CraftingMonitorOpenProviderC2SPacket(AEKey what) {
        this.what = what;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CraftingMonitorOpenProviderC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            IActionHost host;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof CraftingCPUMenu)) {
                return;
            }
            CraftingCPUMenu menu = (CraftingCPUMenu)patt1$temp;
            IGrid grid = null;
            Object target = menu.getTarget();
            if (target instanceof IActionHost && (host = (IActionHost)target).getActionableNode() != null) {
                grid = host.getActionableNode().getGrid();
            }
            if (grid == null) {
                return;
            }
            ICraftingService cs = grid.getCraftingService();
            if (!(cs instanceof CraftingService)) {
                return;
            }
            CraftingService craftingService = (CraftingService)cs;
            Collection patterns = craftingService.getCraftingFor(msg.what);
            if (patterns.isEmpty()) {
                return;
            }
            for (IPatternDetails pattern : patterns) {
                Iterable providers = craftingService.getProviders(pattern);
                for (ICraftingProvider provider : providers) {
                    BlockEntity pbe;
                    PatternProviderLogic ppl;
                    PatternProviderLogicHost host2;
                    if (!(provider instanceof PatternProviderLogic) || (host2 = ((PatternProviderLogicAccessor)(ppl = (PatternProviderLogic)provider)).eap$host()) == null || (pbe = host2.getBlockEntity()) == null || !PatternProviderDataUtil.isProviderAvailable(ppl, grid)) continue;
                    try {
                        List outs;
                        int pageId;
                        if (host2 instanceof AEBasePart) {
                            AEBasePart part = (AEBasePart)host2;
                            host2.openMenu((Player)player, MenuLocators.forPart((AEBasePart)part));
                            CraftingMonitorOpenProviderC2SPacket.highlightWithMessage(pbe.getBlockPos(), part.getSide(), (ResourceKey<Level>)Objects.requireNonNull(pbe.getLevel()).dimension(), 1.0, (Player)player);
                        } else {
                            host2.openMenu((Player)player, MenuLocators.forBlockEntity((BlockEntity)pbe));
                            CraftingMonitorOpenProviderC2SPacket.highlightWithMessage(pbe.getBlockPos(), null, (ResourceKey<Level>)Objects.requireNonNull(pbe.getLevel()).dimension(), 1.0, (Player)player);
                        }
                        int foundSlot = PatternProviderDataUtil.findSlotForPattern(ppl, pattern.getDefinition());
                        if (foundSlot >= 0 && (pageId = foundSlot / 36) > 0) {
                            player.connection.send((CustomPacketPayload)new SetProviderPageS2CPacket(pageId));
                        }
                        if ((outs = pattern.getOutputs()) != null && !outs.isEmpty() && outs.get(0) != null) {
                            AEKey key = ((GenericStack)outs.get(0)).what();
                            player.connection.send((CustomPacketPayload)new SetPatternHighlightS2CPacket(key, true));
                        }
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        });
    }

    private static void highlightWithMessage(BlockPos pos, Direction face, ResourceKey<Level> dim, double multiplier, Player player) {
        if (pos == null || dim == null) {
            return;
        }
        long endTime = System.currentTimeMillis() + (long)(6000.0 * GlodUtil.clamp((double)multiplier, (double)1.0, (double)30.0));
        if (face == null) {
            EAEHighlightHandler.highlight((BlockPos)pos, dim, (long)endTime);
        } else {
            AABB origin = new AABB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125).move(pos);
            Vec3 center = new AABB(pos).getCenter();
            switch (face) {
                case WEST: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.Y, (float)1.5707964f);
                    break;
                }
                case SOUTH: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.Y, (float)((float)Math.PI));
                    break;
                }
                case EAST: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.Y, (float)-1.5707964f);
                    break;
                }
                case UP: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.X, (float)-1.5707964f);
                    break;
                }
                case DOWN: {
                    origin = FCClientUtil.rotor((AABB)origin, (Vec3)center, (Direction.Axis)Direction.Axis.X, (float)1.5707964f);
                }
            }
            EAEHighlightHandler.highlight((BlockPos)pos, (Direction)face, dim, (long)endTime, (AABB)origin);
        }
        if (player != null) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.ex_pattern_access_terminal.pos", (Object[])new Object[]{pos.toShortString(), dim.location().getPath()}), false);
        }
    }
}

