/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.util.IConfigManager;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.parts.crafting.PatternProviderPart;
import com.extendedae_plus.api.config.EAPSettings;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class GlobalToggleProviderModesC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<GlobalToggleProviderModesC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"global_toggle_provider_modes"));
    public static final StreamCodec<FriendlyByteBuf, GlobalToggleProviderModesC2SPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeByte(packet.blockingModeOperation.id);
        buf.writeByte(packet.advancedBlockingOperation.id);
        buf.writeByte(packet.smartDoublingOperation.id);
        buf.writeBlockPos(packet.controllerBlockPos);
    }, buf -> new GlobalToggleProviderModesC2SPacket(Operation.byId(buf.readByte()), Operation.byId(buf.readByte()), Operation.byId(buf.readByte()), buf.readBlockPos()));
    private final Operation blockingModeOperation;
    private final Operation advancedBlockingOperation;
    private final Operation smartDoublingOperation;
    private final BlockPos controllerBlockPos;

    public GlobalToggleProviderModesC2SPacket(Operation blockingModeOperation, Operation advancedBlockingOperation, Operation smartDoublingOperation, BlockPos controllerBlockPos) {
        this.blockingModeOperation = blockingModeOperation;
        this.advancedBlockingOperation = advancedBlockingOperation;
        this.smartDoublingOperation = smartDoublingOperation;
        this.controllerBlockPos = controllerBlockPos;
    }

    public static void handle(GlobalToggleProviderModesC2SPacket message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            ServerLevel level = player.serverLevel();
            BlockEntity blockEntity = level.getBlockEntity(message.controllerBlockPos);
            if (!(blockEntity instanceof IInWorldGridNodeHost)) {
                return;
            }
            IInWorldGridNodeHost gridNodeHost = (IInWorldGridNodeHost)blockEntity;
            IGridNode gridNode = gridNodeHost.getGridNode(null);
            if (gridNode == null) {
                return;
            }
            IGrid grid = gridNode.getGrid();
            if (grid == null) {
                return;
            }
            int affectedCount = GlobalToggleProviderModesC2SPacket.applyToAllPatternProviders(grid, message);
            player.displayClientMessage((Component)Component.literal((String)("E+ \u5168\u5c40\u5207\u6362\u5df2\u5e94\u7528\u5230 " + affectedCount + " \u4e2a\u6837\u677f\u4f9b\u5e94\u5668")), true);
        });
    }

    private static int applyToAllPatternProviders(IGrid grid, GlobalToggleProviderModesC2SPacket message) {
        int affectedCount = 0;
        HashSet<PatternProviderLogic> uniqueLogics = new HashSet<PatternProviderLogic>();
        GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getMachines(PatternProviderBlockEntity.class), uniqueLogics);
        GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getActiveMachines(PatternProviderBlockEntity.class), uniqueLogics);
        GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getMachines(PatternProviderPart.class), uniqueLogics);
        GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getActiveMachines(PatternProviderPart.class), uniqueLogics);
        GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getMachines(PatternProviderLogicHost.class), uniqueLogics);
        GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getActiveMachines(PatternProviderLogicHost.class), uniqueLogics);
        GlobalToggleProviderModesC2SPacket.collectByReflection(grid, uniqueLogics, "com.glodblock.github.extendedae.common.parts.PartExPatternProvider");
        GlobalToggleProviderModesC2SPacket.collectByReflection(grid, uniqueLogics, "com.glodblock.github.extendedae.common.tileentities.TileExPatternProvider");
        for (PatternProviderLogic logic : uniqueLogics) {
            if (!GlobalToggleProviderModesC2SPacket.applyOperationToLogic(logic, message)) continue;
            ++affectedCount;
        }
        return affectedCount;
    }

    private static void collectLogicsFromMachineSet(Set<?> machineSet, Set<PatternProviderLogic> target) {
        if (machineSet == null) {
            return;
        }
        for (Object obj : machineSet) {
            GlobalToggleProviderModesC2SPacket.addLogicIfPresent(target, obj);
        }
    }

    private static void collectByReflection(IGrid grid, Set<PatternProviderLogic> target, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getMachines(clazz), target);
            GlobalToggleProviderModesC2SPacket.collectLogicsFromMachineSet(grid.getActiveMachines(clazz), target);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void addLogicIfPresent(Set<PatternProviderLogic> target, Object obj) {
        if (obj == null) {
            return;
        }
        try {
            PatternProviderLogicHost host;
            if (obj instanceof PatternProviderLogicHost && (host = (PatternProviderLogicHost)obj).getLogic() != null) {
                target.add(host.getLogic());
                return;
            }
            Method method = obj.getClass().getMethod("getLogic", new Class[0]);
            Object result = method.invoke(obj, new Object[0]);
            if (result instanceof PatternProviderLogic) {
                PatternProviderLogic logic = (PatternProviderLogic)result;
                target.add(logic);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean applyOperationToLogic(PatternProviderLogic logic, GlobalToggleProviderModesC2SPacket message) {
        boolean target;
        boolean current;
        if (logic == null) {
            return false;
        }
        IConfigManager configManager = logic.getConfigManager();
        if (configManager == null) {
            return false;
        }
        boolean anyChanged = false;
        if (message.blockingModeOperation != Operation.NOOP) {
            current = GlobalToggleProviderModesC2SPacket.isBlockingModeEnabled(logic);
            target = GlobalToggleProviderModesC2SPacket.calculateTargetState(current, message.blockingModeOperation);
            configManager.putSetting(Settings.BLOCKING_MODE, (Enum)(target ? YesNo.YES : YesNo.NO));
            anyChanged |= current != target;
        }
        if (message.advancedBlockingOperation != Operation.NOOP) {
            current = configManager.getSetting(EAPSettings.ADVANCED_BLOCKING) == YesNo.YES;
            target = GlobalToggleProviderModesC2SPacket.calculateTargetState(current, message.advancedBlockingOperation);
            configManager.putSetting(EAPSettings.ADVANCED_BLOCKING, (Enum)(target ? YesNo.YES : YesNo.NO));
            anyChanged |= current != target;
        }
        if (message.smartDoublingOperation != Operation.NOOP) {
            current = configManager.getSetting(EAPSettings.SMART_DOUBLING) == YesNo.YES;
            target = GlobalToggleProviderModesC2SPacket.calculateTargetState(current, message.smartDoublingOperation);
            configManager.putSetting(EAPSettings.SMART_DOUBLING, (Enum)(target ? YesNo.YES : YesNo.NO));
            anyChanged |= current != target;
        }
        if (anyChanged) {
            try {
                logic.saveChanges();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return anyChanged;
    }

    private static boolean calculateTargetState(boolean currentValue, Operation operation) {
        return switch (operation.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> true;
            case 2 -> false;
            case 3 -> {
                if (!currentValue) {
                    yield true;
                }
                yield false;
            }
            case 0 -> currentValue;
        };
    }

    private static boolean isBlockingModeEnabled(PatternProviderLogic logic) {
        try {
            return logic.isBlocking();
        }
        catch (Throwable t) {
            return false;
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Operation {
        NOOP(0),
        SET_TRUE(1),
        SET_FALSE(2),
        TOGGLE(3);

        public final byte id;

        private Operation(byte id) {
            this.id = id;
        }

        static Operation byId(byte id) {
            return switch (id) {
                case 1 -> SET_TRUE;
                case 2 -> SET_FALSE;
                case 3 -> TOGGLE;
                default -> NOOP;
            };
        }
    }
}

