/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.items.tools.powered.WirelessCraftingTerminalItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.locator.ItemMenuHostLocator;
import com.extendedae_plus.menu.locator.CuriosItemLocator;
import com.extendedae_plus.util.wireless.WirelessTerminalLocator;
import de.mari_023.ae2wtlib.api.registration.WTDefinition;
import de.mari_023.ae2wtlib.api.terminal.WTMenuHost;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PickFromWirelessC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<PickFromWirelessC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"pick_from_wireless"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PickFromWirelessC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        buf.writeBlockPos(pkt.pos);
        buf.writeEnum((Enum)pkt.face);
        buf.writeDouble(pkt.hitLoc.x);
        buf.writeDouble(pkt.hitLoc.y);
        buf.writeDouble(pkt.hitLoc.z);
    }, buf -> new PickFromWirelessC2SPacket(buf.readBlockPos(), (Direction)buf.readEnum(Direction.class), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble())));
    private final BlockPos pos;
    private final Direction face;
    private final Vec3 hitLoc;

    public PickFromWirelessC2SPacket(BlockPos pos, Direction face, Vec3 hitLoc) {
        this.pos = pos;
        this.face = face;
        this.hitLoc = hitLoc;
    }

    public static void handle(PickFromWirelessC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            int space;
            boolean placeToMainHand;
            IGrid grid;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (player.isCreative()) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockState state = level.getBlockState(msg.pos);
            if (state == null || state.isAir()) {
                return;
            }
            WirelessTerminalLocator.LocatedTerminal located = WirelessTerminalLocator.find((Player)player);
            ItemStack terminal = located.stack;
            if (terminal.isEmpty()) {
                return;
            }
            boolean usedWtHost = false;
            String curiosSlotId = located.getCuriosSlotId();
            int curiosIndex = located.getCuriosIndex();
            if (curiosSlotId != null && curiosIndex >= 0) {
                patt1$temp = terminal.getItem();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct = patt1$temp instanceof WirelessCraftingTerminalItem ? (c = (WirelessCraftingTerminalItem)patt1$temp) : null;
                if (wct != null) {
                    v1 = wct;
                } else {
                    patt1$temp = terminal.getItem();
                    if (patt1$temp instanceof WirelessTerminalItem) {
                        t = (WirelessTerminalItem)patt1$temp;
                        v1 = t;
                    } else {
                        v1 = wt = null;
                    }
                }
                if (wt != null) {
                    grid = wt.getLinkedGrid(terminal, (Level)level, null);
                    if (grid == null) {
                        return;
                    }
                    if (!wt.hasPower((Player)player, 0.5, terminal)) {
                        return;
                    }
                } else {
                    WTDefinition def = WTDefinition.ofOrNull((ItemStack)terminal);
                    if (def == null) {
                        return;
                    }
                    WTMenuHost wtHost = def.wTMenuHostFactory().create(def.item(), (Player)player, (ItemMenuHostLocator)new CuriosItemLocator(curiosSlotId, curiosIndex), (p, sub) -> {});
                    if (wtHost == null || wtHost.getActionableNode() == null || wtHost.getActionableNode().getGrid() == null) {
                        return;
                    }
                    grid = wtHost.getActionableNode().getGrid();
                    usedWtHost = true;
                }
            } else {
                patt1$temp = terminal.getItem();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct = patt1$temp instanceof WirelessCraftingTerminalItem ? (c = (WirelessCraftingTerminalItem)patt1$temp) : null;
                if (wct != null) {
                    v3 = wct;
                } else {
                    patt1$temp = terminal.getItem();
                    if (patt1$temp instanceof WirelessTerminalItem) {
                        t = (WirelessTerminalItem)patt1$temp;
                        v3 = t;
                    } else {
                        v3 = wt = null;
                    }
                }
                if (wt == null) {
                    return;
                }
                grid = wt.getLinkedGrid(terminal, (Level)level, null);
                if (grid == null) {
                    return;
                }
                if (!wt.hasPower((Player)player, 0.5, terminal)) {
                    return;
                }
            }
            BlockHitResult bhr = new BlockHitResult(msg.hitLoc, msg.face, msg.pos, true);
            ItemStack picked = state.getBlock().getCloneItemStack(state, (HitResult)bhr, (LevelReader)level, msg.pos, (Player)player);
            if (picked.isEmpty()) {
                picked = state.getBlock().asItem().getDefaultInstance();
            }
            if (picked.isEmpty()) {
                return;
            }
            int targetMax = picked.getMaxStackSize();
            AEItemKey targetKey = AEItemKey.of((ItemStack)picked);
            IEnergyService energy = grid.getEnergyService();
            MEStorage storage = grid.getStorageService().getInventory();
            ItemStack inHand = player.getMainHandItem();
            Inventory inv = player.getInventory();
            boolean handIsSameItem = !inHand.isEmpty() && AEItemKey.of((ItemStack)inHand).equals((Object)targetKey);
            boolean bl = placeToMainHand = inHand.isEmpty() || handIsSameItem && inHand.getCount() < inHand.getMaxStackSize();
            if (placeToMainHand) {
                space = inHand.isEmpty() ? targetMax : Math.min(targetMax, inHand.getMaxStackSize() - inHand.getCount());
            } else {
                int free = inv.getFreeSlot();
                if (free == -1) {
                    return;
                }
                space = targetMax;
            }
            if (space <= 0) {
                return;
            }
            long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)storage, (AEKey)targetKey, (long)space, (IActionSource)new PlayerSource((Player)player));
            if (extracted <= 0L) {
                return;
            }
            if (placeToMainHand) {
                if (inHand.isEmpty()) {
                    inv.setItem(inv.selected, targetKey.toStack((int)extracted));
                } else {
                    int add = (int)Math.min(extracted, (long)(inHand.getMaxStackSize() - inHand.getCount()));
                    if (add > 0) {
                        inHand.grow(add);
                        inv.setItem(inv.selected, inHand);
                    }
                }
            } else {
                int free = inv.getFreeSlot();
                if (free == -1) {
                    StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)storage, (AEKey)targetKey, (long)extracted, (IActionSource)new PlayerSource((Player)player));
                    return;
                }
                inv.setItem(free, targetKey.toStack((int)extracted));
            }
            if (!usedWtHost) {
                WirelessCraftingTerminalItem wt2;
                WirelessCraftingTerminalItem c2;
                WirelessCraftingTerminalItem wct2;
                Item patt1$temp = terminal.getItem();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct2 = patt1$temp instanceof WirelessCraftingTerminalItem ? (c2 = (WirelessCraftingTerminalItem)patt1$temp) : null;
                if (wct2 != null) {
                    v6 = wct2;
                } else {
                    Item patt1$temp2 = terminal.getItem();
                    if (patt1$temp2 instanceof WirelessTerminalItem) {
                        WirelessTerminalItem t2 = (WirelessTerminalItem)patt1$temp2;
                        v6 = t2;
                    } else {
                        v6 = wt2 = null;
                    }
                }
                if (wt2 != null) {
                    wt2.usePower((Player)player, Math.max(0.5, (double)extracted * 0.05), terminal);
                }
            }
            located.commit();
            player.containerMenu.broadcastChanges();
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

