/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.menu.implementations.PatternProviderMenu;
import com.extendedae_plus.mixin.ae2.accessor.PatternProviderMenuAdvancedAccessor;
import com.extendedae_plus.util.ExtendedAELogger;
import com.extendedae_plus.util.PatternProviderDataUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ScalePatternsC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ScalePatternsC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extendedae_plus", (String)"scale_patterns"));
    public static final StreamCodec<FriendlyByteBuf, ScalePatternsC2SPacket> STREAM_CODEC = StreamCodec.of((buf, pkt) -> buf.writeEnum((Enum)pkt.op), buf -> new ScalePatternsC2SPacket((Operation)buf.readEnum(Operation.class)));
    private final Operation op;

    public ScalePatternsC2SPacket(Operation op) {
        this.op = op;
    }

    public Operation op() {
        return this.op;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ScalePatternsC2SPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof PatternProviderMenu)) {
                return;
            }
            PatternProviderMenu menu = (PatternProviderMenu)patt1$temp;
            try {
                boolean multiply;
                double factor;
                PatternProviderMenuAdvancedAccessor accessor = (PatternProviderMenuAdvancedAccessor)menu;
                PatternProviderLogic logic = accessor.eap$logic();
                if (logic == null) {
                    return;
                }
                switch (msg.op.ordinal()) {
                    case 0: {
                        factor = 2.0;
                        multiply = true;
                        break;
                    }
                    case 1: {
                        factor = 2.0;
                        multiply = false;
                        break;
                    }
                    case 2: {
                        factor = 5.0;
                        multiply = true;
                        break;
                    }
                    case 3: {
                        factor = 5.0;
                        multiply = false;
                        break;
                    }
                    case 4: {
                        factor = 10.0;
                        multiply = true;
                        break;
                    }
                    case 5: {
                        factor = 10.0;
                        multiply = false;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                PatternProviderDataUtil.PatternScalingResult result = multiply ? PatternProviderDataUtil.multiplyPatternAmounts(logic, factor) : PatternProviderDataUtil.dividePatternAmounts(logic, factor);
                logic.saveChanges();
                String summary = String.format("\u6837\u677f\u7f29\u653e(%s x%.0f): \u5171%d, \u6210\u529f%d, \u5931\u8d25%d", multiply ? "\u500d\u589e" : "\u9664\u6cd5", factor, result.getTotalPatterns(), result.getScaledPatterns(), result.getFailedPatterns());
                player.displayClientMessage((Component)Component.literal((String)("[EAP] " + summary)), true);
            }
            catch (Throwable t) {
                ExtendedAELogger.LOGGER.error("[EAP] Handle ScalePatternsC2SPacket failed", t);
            }
        });
    }

    public static enum Operation {
        MUL2,
        DIV2,
        MUL5,
        DIV5,
        MUL10,
        DIV10;

    }
}

