/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network.packet;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import appeng.menu.AEBaseMenu;
import appeng.util.EnumCycler;
import com.extendedae_plus.api.config.EAPSettings;
import com.extendedae_plus.util.ExtendedAELogger;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public record EAPConfigButtonPacket(Setting<?> option, boolean rotationDirection) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, EAPConfigButtonPacket> STREAM_CODEC = StreamCodec.ofMember(EAPConfigButtonPacket::write, EAPConfigButtonPacket::decode);
    public static final CustomPacketPayload.Type<EAPConfigButtonPacket> TYPE = CustomAppEngPayload.createType((String)"eap_config_button");

    @NotNull
    public CustomPacketPayload.Type<EAPConfigButtonPacket> type() {
        return TYPE;
    }

    public static EAPConfigButtonPacket decode(RegistryFriendlyByteBuf stream) {
        Setting<?> option = EAPSettings.getOrThrow(stream.readUtf());
        boolean rotationDirection = stream.readBoolean();
        return new EAPConfigButtonPacket(option, rotationDirection);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeUtf(this.option.getName());
        data.writeBoolean(this.rotationDirection);
    }

    public void handleOnServer(ServerPlayer player) {
        AEBaseMenu baseMenu;
        Object object;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AEBaseMenu && (object = (baseMenu = (AEBaseMenu)abstractContainerMenu).getTarget()) instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)object;
            IConfigManager cm = configurableObject.getConfigManager();
            if (cm.hasSetting(this.option)) {
                this.cycleSetting(cm, this.option);
            } else {
                ExtendedAELogger.LOGGER.info("Ignoring unsupported setting {} sent by client on {}", this.option, baseMenu.getTarget());
            }
        }
    }

    private <T extends Enum<T>> void cycleSetting(IConfigManager cm, Setting<T> setting) {
        Enum currentValue = cm.getSetting(setting);
        Enum nextValue = EnumCycler.rotateEnum((Enum)currentValue, (boolean)this.rotationDirection, (Set)setting.getValues());
        cm.putSetting(setting, nextValue);
    }
}

