/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.entitySpeed;

import com.extendedae_plus.util.ExtendedAELogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ConfigParsingUtils {
    private static volatile List<Pattern> cachedBlacklist = null;
    private static volatile List<MultiplierEntry> cachedMultiplierEntries = null;
    private static volatile List<String> cachedBlacklistSourceSnapshot = null;
    private static volatile List<String> cachedMultiplierSourceSnapshot = null;
    private static final Object CACHE_LOCK = new Object();

    private ConfigParsingUtils() {
    }

    public static Pattern compilePattern(String raw) {
        if (raw == null || raw.trim().isEmpty()) {
            ExtendedAELogger.LOGGER.warn("Invalid pattern: {}", (Object)raw);
            throw new IllegalArgumentException("Pattern is null or empty");
        }
        if ((raw = raw.trim()).contains(".*") || raw.matches(".*[\\[\\(\\+\\{\\\\].*")) {
            try {
                return Pattern.compile("^" + raw + "$");
            }
            catch (PatternSyntaxException e) {
                ExtendedAELogger.LOGGER.warn("Failed to compile regex pattern '{}': {}", (Object)raw, (Object)e.getMessage());
            }
        }
        if (raw.contains("*") || raw.contains("?")) {
            StringBuilder sb = new StringBuilder("^");
            block6: for (char c : raw.toCharArray()) {
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block6;
                    }
                    case '?': {
                        sb.append('.');
                        continue block6;
                    }
                    default: {
                        if (".\\+[]{}()^$|".indexOf(c) >= 0) {
                            sb.append('\\');
                        }
                        sb.append(c);
                    }
                }
            }
            sb.append('$');
            return Pattern.compile(sb.toString());
        }
        return Pattern.compile("^" + Pattern.quote(raw) + "$");
    }

    public static MultiplierEntry parseMultiplierEntry(String entry) {
        double multiplier;
        if (entry == null || entry.trim().isEmpty()) {
            return null;
        }
        String[] parts = entry.trim().split("\\s+");
        if (parts.length < 2) {
            ExtendedAELogger.LOGGER.warn("Invalid multiplier entry: {}", (Object)entry);
            return null;
        }
        String key = parts[0];
        String val = parts[1].toLowerCase();
        if (val.endsWith("x")) {
            val = val.substring(0, val.length() - 1);
        }
        try {
            multiplier = Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            ExtendedAELogger.LOGGER.warn("Invalid multiplier value in '{}': {}", (Object)entry, (Object)val);
            return null;
        }
        try {
            Pattern pattern = ConfigParsingUtils.compilePattern(key);
            return new MultiplierEntry(pattern, multiplier);
        }
        catch (IllegalArgumentException e) {
            ExtendedAELogger.LOGGER.warn("Failed to compile pattern in '{}': {}", (Object)entry, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isBlockBlacklisted(String blockId, List<? extends String> blacklist) {
        if (blockId == null) {
            return false;
        }
        return ConfigParsingUtils.getCachedBlacklist(blacklist).stream().anyMatch(p -> p.matcher(blockId).matches());
    }

    public static double getMultiplierForBlock(String blockId, List<? extends String> multipliers) {
        if (blockId == null) {
            return 1.0;
        }
        double maxMultiplier = 1.0;
        for (MultiplierEntry me : ConfigParsingUtils.getCachedMultiplierEntries(multipliers)) {
            if (!me.pattern.matcher(blockId).matches()) continue;
            maxMultiplier = Math.max(maxMultiplier, me.multiplier);
        }
        return maxMultiplier;
    }

    public static List<Pattern> compilePatterns(List<? extends String> raw) {
        ArrayList<Pattern> out = new ArrayList<Pattern>();
        if (raw == null) {
            return out;
        }
        for (String string : raw) {
            if (string == null || string.trim().isEmpty()) continue;
            try {
                out.add(ConfigParsingUtils.compilePattern(string));
            }
            catch (IllegalArgumentException e) {
                ExtendedAELogger.LOGGER.warn("Failed to compile pattern '{}': {}", (Object)string, (Object)e.getMessage());
            }
        }
        return out;
    }

    public static List<MultiplierEntry> parseMultiplierList(List<? extends String> raw) {
        ArrayList<MultiplierEntry> out = new ArrayList<MultiplierEntry>();
        if (raw == null) {
            return out;
        }
        for (String string : raw) {
            MultiplierEntry me = ConfigParsingUtils.parseMultiplierEntry(string);
            if (me == null) continue;
            out.add(me);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pattern> getCachedBlacklist(List<? extends String> source) {
        List<String> normalized = ConfigParsingUtils.normalizeSource(source);
        if (cachedBlacklist != null && ConfigParsingUtils.listEquals(cachedBlacklistSourceSnapshot, normalized)) {
            return Collections.unmodifiableList(cachedBlacklist);
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (cachedBlacklist == null || !ConfigParsingUtils.listEquals(cachedBlacklistSourceSnapshot, normalized)) {
                cachedBlacklist = ConfigParsingUtils.compilePatterns(normalized);
                cachedBlacklistSourceSnapshot = normalized.isEmpty() ? Collections.emptyList() : new ArrayList<String>(normalized);
            }
            return Collections.unmodifiableList(cachedBlacklist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MultiplierEntry> getCachedMultiplierEntries(List<? extends String> source) {
        List<String> normalized = ConfigParsingUtils.normalizeSource(source);
        if (cachedMultiplierEntries != null && ConfigParsingUtils.listEquals(cachedMultiplierSourceSnapshot, normalized)) {
            return Collections.unmodifiableList(cachedMultiplierEntries);
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (cachedMultiplierEntries == null || !ConfigParsingUtils.listEquals(cachedMultiplierSourceSnapshot, normalized)) {
                cachedMultiplierEntries = ConfigParsingUtils.parseMultiplierList(normalized);
                cachedMultiplierSourceSnapshot = normalized.isEmpty() ? Collections.emptyList() : new ArrayList<String>(normalized);
            }
            return Collections.unmodifiableList(cachedMultiplierEntries);
        }
    }

    private static List<String> normalizeSource(List<? extends String> source) {
        ArrayList<String> out = new ArrayList<String>();
        if (source == null) {
            return out;
        }
        for (String string : source) {
            String t;
            if (string == null || (t = string.trim()).isEmpty()) continue;
            out.add(t);
        }
        return out;
    }

    private static boolean listEquals(List<String> a, List<String> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            cachedBlacklist = null;
            cachedMultiplierEntries = null;
            cachedBlacklistSourceSnapshot = null;
            cachedMultiplierSourceSnapshot = null;
        }
    }

    public static final class MultiplierEntry {
        public final Pattern pattern;
        public final double multiplier;

        public MultiplierEntry(Pattern pattern, double multiplier) {
            this.pattern = pattern;
            this.multiplier = multiplier;
        }
    }
}

