/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.entitySpeed;

import appeng.api.upgrades.IUpgradeInventory;
import com.extendedae_plus.config.ModConfigs;
import com.extendedae_plus.items.materials.EntitySpeedCardItem;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;

public final class PowerUtils {
    private PowerUtils() {
    }

    public static long computeProductWithCap(IUpgradeInventory upgrades, int maxCards) {
        ArrayList<Integer> multipliers = new ArrayList<Integer>();
        int considered = 0;
        for (ItemStack stack : upgrades) {
            if (considered >= maxCards) break;
            if (stack == null || stack.isEmpty() || !(stack.getItem() instanceof EntitySpeedCardItem)) continue;
            byte multVal = EntitySpeedCardItem.readMultiplier(stack);
            int count = Math.min(stack.getCount(), maxCards - considered);
            for (int i = 0; i < count; ++i) {
                multipliers.add(Integer.valueOf(multVal));
                ++considered;
            }
        }
        long product = 1L;
        int highest = 1;
        for (Integer m : multipliers) {
            if (m == null || m <= 0) continue;
            product *= (long)m.intValue();
            highest = Math.max(highest, m);
        }
        return Math.min(product, PowerUtils.capForHighestMultiplier(highest));
    }

    private static long capForHighestMultiplier(int highestMultiplier) {
        if (highestMultiplier >= 16) {
            return 1024L;
        }
        if (highestMultiplier >= 8) {
            return 256L;
        }
        if (highestMultiplier >= 4) {
            return 64L;
        }
        if (highestMultiplier >= 2) {
            return 8L;
        }
        return 1L;
    }

    public static double computeFinalPowerForProduct(long product, int energyCardCount) {
        if (product <= 1L) {
            return 0.0;
        }
        double base = ((Integer)ModConfigs.ENTITY_TICKER_COST.get()).intValue();
        double log2 = Math.log(product) / Math.log(2.0);
        double raw = product == 2L ? base * 4.0 : (product <= 256L ? base * Math.pow(2.0, 1.5 * log2) * 2.0 : base * Math.pow(2.0, 2.5 * log2));
        return raw * PowerUtils.getRemainingRatio(energyCardCount) / 8.0;
    }

    public static double getRemainingRatio(int energyCardCount) {
        if (energyCardCount <= 0) {
            return 1.0;
        }
        if (energyCardCount == 1) {
            return 0.9;
        }
        if (energyCardCount >= 8) {
            return 0.5;
        }
        return 1.0 - 0.5 * (1.0 - Math.pow(0.7, energyCardCount));
    }

    public static String formatPercentage(double ratio) {
        double pct = ratio * 100.0;
        return Math.abs(pct - (double)Math.round(pct)) < 1.0E-9 ? String.format("%d%%", Math.round(pct)) : String.format("%.2f%%", pct);
    }
}

