/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.wireless;

import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class WirelessTeamUtil {
    private static final boolean FTB_TEAMS_LOADED = ModList.get().isLoaded("ftbteams");

    public static UUID getNetworkOwnerUUID(@Nullable ServerLevel level, UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        if (!FTB_TEAMS_LOADED) {
            return playerUUID;
        }
        if (level == null) {
            return playerUUID;
        }
        try {
            return WirelessTeamUtil.getTeamUUID(level, playerUUID);
        }
        catch (Exception e) {
            return playerUUID;
        }
    }

    public static Component getNetworkOwnerName(@Nullable ServerLevel level, UUID playerUUID) {
        ServerPlayer player;
        if (FTB_TEAMS_LOADED && level != null) {
            try {
                return WirelessTeamUtil.getTeamName(level, playerUUID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (level != null && (player = level.getServer().getPlayerList().getPlayer(playerUUID)) != null) {
            return player.getName();
        }
        return Component.literal((String)playerUUID.toString());
    }

    public static boolean hasNetworkOwner(@Nullable ServerLevel level, UUID playerUUID) {
        if (FTB_TEAMS_LOADED && level != null) {
            try {
                return WirelessTeamUtil.hasTeamOwner(level, playerUUID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (level != null) {
            return level.getServer().getPlayerList().getPlayer(playerUUID) != null;
        }
        return false;
    }

    private static UUID getTeamUUID(ServerLevel level, UUID playerUUID) {
        try {
            Class<?> optionalClass;
            boolean isPresent;
            Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Boolean isLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
            if (!isLoaded.booleanValue()) {
                return playerUUID;
            }
            Object getManager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
            if (getManager == null) {
                return playerUUID;
            }
            Class<?> managerClass = getManager.getClass();
            Method getTeamForPlayer = managerClass.getMethod("getTeamForPlayerID", UUID.class);
            Object teamOptional = getTeamForPlayer.invoke(getManager, playerUUID);
            if (teamOptional != null && (isPresent = ((Boolean)(optionalClass = teamOptional.getClass()).getMethod("isPresent", new Class[0]).invoke(teamOptional, new Object[0])).booleanValue())) {
                Object team = optionalClass.getMethod("get", new Class[0]).invoke(teamOptional, new Object[0]);
                Class<?> teamClass = team.getClass();
                return (UUID)teamClass.getMethod("getTeamId", new Class[0]).invoke(team, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return playerUUID;
    }

    private static Component getTeamName(ServerLevel level, UUID playerUUID) {
        try {
            Class<?> optionalClass;
            boolean isPresent;
            Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Boolean isLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
            if (!isLoaded.booleanValue()) {
                ServerPlayer player = level.getServer().getPlayerList().getPlayer(playerUUID);
                if (player != null) {
                    return player.getName();
                }
                return Component.literal((String)playerUUID.toString());
            }
            Object getManager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
            if (getManager == null) {
                return Component.literal((String)playerUUID.toString());
            }
            Class<?> managerClass = getManager.getClass();
            Method getTeamForPlayer = managerClass.getMethod("getTeamForPlayerID", UUID.class);
            Object teamOptional = getTeamForPlayer.invoke(getManager, playerUUID);
            if (teamOptional != null && (isPresent = ((Boolean)(optionalClass = teamOptional.getClass()).getMethod("isPresent", new Class[0]).invoke(teamOptional, new Object[0])).booleanValue())) {
                Object team = optionalClass.getMethod("get", new Class[0]).invoke(teamOptional, new Object[0]);
                Class<?> teamClass = team.getClass();
                return (Component)teamClass.getMethod("getName", new Class[0]).invoke(team, new Object[0]);
            }
        }
        catch (Exception apiClass) {
            // empty catch block
        }
        ServerPlayer player = level.getServer().getPlayerList().getPlayer(playerUUID);
        if (player != null) {
            return player.getName();
        }
        return Component.literal((String)playerUUID.toString());
    }

    private static boolean hasTeamOwner(ServerLevel level, UUID playerUUID) {
        try {
            Class<?> apiClass = Class.forName("dev.ftb.mods.ftbteams.api.FTBTeamsAPI");
            Object api = apiClass.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Boolean isLoaded = (Boolean)api.getClass().getMethod("isManagerLoaded", new Class[0]).invoke(api, new Object[0]);
            if (!isLoaded.booleanValue()) {
                return level.getServer().getPlayerList().getPlayer(playerUUID) != null;
            }
            Object getManager = api.getClass().getMethod("getManager", new Class[0]).invoke(api, new Object[0]);
            if (getManager == null) {
                return level.getServer().getPlayerList().getPlayer(playerUUID) != null;
            }
            Class<?> managerClass = getManager.getClass();
            Method getTeamForPlayer = managerClass.getMethod("getTeamForPlayerID", UUID.class);
            Object teamOptional = getTeamForPlayer.invoke(getManager, playerUUID);
            if (teamOptional != null) {
                Class<?> optionalClass = teamOptional.getClass();
                return (Boolean)optionalClass.getMethod("isPresent", new Class[0]).invoke(teamOptional, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return level.getServer().getPlayerList().getPlayer(playerUUID) != null;
    }
}

