/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.menu;

import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.OptionalFakeSlot;
import com.extendedae_plus.ae.parts.EntitySpeedTickerPart;
import com.extendedae_plus.ae.screen.EntitySpeedTickerScreen;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.init.ModMenuTypes;
import com.extendedae_plus.util.entitySpeed.ConfigParsingUtils;
import com.extendedae_plus.util.entitySpeed.PowerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class EntitySpeedTickerMenu
extends UpgradeableMenu<EntitySpeedTickerPart> {
    @GuiSync(value=716)
    public boolean accelerateEnabled = true;
    @GuiSync(value=717)
    public int entitySpeedCardCount;
    @GuiSync(value=718)
    public int energyCardCount;
    @GuiSync(value=719)
    public int effectiveSpeed = 1;
    @GuiSync(value=720)
    public double multiplier = 1.0;
    @GuiSync(value=721)
    public boolean targetBlacklisted = false;
    @GuiSync(value=722)
    public boolean networkEnergySufficient = true;

    public EntitySpeedTickerMenu(int id, Inventory ip, EntitySpeedTickerPart host) {
        super((MenuType)ModMenuTypes.ENTITY_TICKER_MENU.get(), id, ip, (IUpgradeableObject)host);
        if (host != null) {
            host.menu = this;
            this.accelerateEnabled = host.getAccelerateEnabled();
        }
    }

    public boolean getAccelerateEnabled() {
        return this.accelerateEnabled;
    }

    public void setAccelerateEnabled(boolean enabled) {
        this.accelerateEnabled = enabled;
        if (this.getHost() != null) {
            ((EntitySpeedTickerPart)this.getHost()).setAccelerateEnabled(enabled);
        }
        this.m_38946_();
    }

    public void setNetworkEnergySufficient(boolean sufficient) {
        this.networkEnergySufficient = sufficient;
        this.m_38946_();
    }

    public void onServerDataSync() {
        super.onServerDataSync();
        this.updateCardCounts();
        this.updateTargetStatus();
        this.updateEffectiveSpeed();
        this.updateNetworkEnergyStatus();
        if (this.isClientSide()) {
            this.refreshClientGui();
        }
    }

    public void onSlotChange(Slot slot) {
        super.onSlotChange(slot);
        if (this.isClientSide()) {
            this.updateCardCounts();
            this.updateEffectiveSpeed();
            this.refreshClientGui();
        }
    }

    public void m_38946_() {
        for (Object o : this.f_38839_) {
            OptionalFakeSlot fs;
            if (!(o instanceof OptionalFakeSlot) || (fs = (OptionalFakeSlot)o).isSlotEnabled() || fs.getDisplayStack().m_41619_()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    private void updateCardCounts() {
        this.entitySpeedCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)ModItems.ENTITY_SPEED_CARD.get());
        this.energyCardCount = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
    }

    private void updateTargetStatus() {
        BlockEntity target = this.getTargetBlockEntity();
        if (target == null) {
            this.multiplier = 1.0;
            this.targetBlacklisted = false;
            return;
        }
        String blockId = ForgeRegistries.BLOCKS.getKey((Object)target.m_58900_().m_60734_()).toString();
        this.multiplier = ConfigParsingUtils.getMultiplierForBlock(blockId);
        this.targetBlacklisted = ConfigParsingUtils.isBlockBlacklisted(blockId);
    }

    private void updateEffectiveSpeed() {
        this.effectiveSpeed = this.targetBlacklisted ? 0 : PowerUtils.computeProductWithCap(this.getUpgrades(), 8);
    }

    private void updateNetworkEnergyStatus() {
        if (!this.isClientSide() && this.getHost() != null) {
            this.networkEnergySufficient = ((EntitySpeedTickerPart)this.getHost()).getNetworkEnergySufficient();
        }
    }

    private void refreshClientGui() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof EntitySpeedTickerScreen) {
            EntitySpeedTickerScreen screen2 = (EntitySpeedTickerScreen)screen;
            screen2.refreshGui();
        }
    }

    private BlockEntity getTargetBlockEntity() {
        return this.getHost() != null ? ((EntitySpeedTickerPart)this.getHost()).getLevel().m_7702_(((EntitySpeedTickerPart)this.getHost()).getBlockEntity().m_58899_().m_121945_(((EntitySpeedTickerPart)this.getHost()).getSide())) : null;
    }
}

