/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.client.render.crafting;

import appeng.block.crafting.ICraftingUnitType;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.LightBakedModel;
import com.extendedae_plus.content.crafting.EPlusCraftingUnitType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;

public class EPlusCraftingCubeModelProvider
extends AbstractCraftingUnitModelProvider<EPlusCraftingUnitType> {
    public static final ChunkRenderTypeSet CUTOUT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    private static final List<Material> MATERIALS = new ArrayList<Material>();
    protected static final Material RING_CORNER = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "ring_corner");
    protected static final Material RING_SIDE_HOR = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "ring_side_hor");
    protected static final Material RING_SIDE_VER = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "ring_side_ver");
    protected static final Material LIGHT_BASE = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "light_base");
    protected static final Material ACCELERATOR_4X_LIGHT = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "4x_accelerator_light");
    protected static final Material ACCELERATOR_16X_LIGHT = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "16x_accelerator_light");
    protected static final Material ACCELERATOR_64X_LIGHT = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "64x_accelerator_light");
    protected static final Material ACCELERATOR_256X_LIGHT = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "256x_accelerator_light");
    protected static final Material ACCELERATOR_1024X_LIGHT = EPlusCraftingCubeModelProvider.texture("extendedae_plus", "1024x_accelerator_light");

    public EPlusCraftingCubeModelProvider(EPlusCraftingUnitType type) {
        super((ICraftingUnitType)type);
    }

    public List<Material> getMaterials() {
        return Collections.unmodifiableList(MATERIALS);
    }

    public BakedModel getBakedModel(Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite ringCorner = spriteGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = spriteGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = spriteGetter.apply(RING_SIDE_VER);
        return new LightBakedModel(ringCorner, ringSideHor, ringSideVer, spriteGetter.apply(LIGHT_BASE), this.getLightMaterial(spriteGetter)){

            public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
                return CUTOUT;
            }
        };
    }

    private TextureAtlasSprite getLightMaterial(Function<Material, TextureAtlasSprite> textureGetter) {
        return switch ((EPlusCraftingUnitType)this.type) {
            default -> throw new IncompatibleClassChangeError();
            case EPlusCraftingUnitType.ACCELERATOR_4x -> textureGetter.apply(ACCELERATOR_4X_LIGHT);
            case EPlusCraftingUnitType.ACCELERATOR_16x -> textureGetter.apply(ACCELERATOR_16X_LIGHT);
            case EPlusCraftingUnitType.ACCELERATOR_64x -> textureGetter.apply(ACCELERATOR_64X_LIGHT);
            case EPlusCraftingUnitType.ACCELERATOR_256x -> textureGetter.apply(ACCELERATOR_256X_LIGHT);
            case EPlusCraftingUnitType.ACCELERATOR_1024x -> textureGetter.apply(ACCELERATOR_1024X_LIGHT);
        };
    }

    private static Material texture(String namespace, String name) {
        Material mat = new Material(TextureAtlas.f_118259_, new ResourceLocation(namespace, "block/crafting/" + name));
        MATERIALS.add(mat);
        return mat;
    }
}

