/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.items;

import com.extendedae_plus.init.ModItems;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BasicCoreItem
extends Item {
    private static final String NBT_MODEL = "CustomModelData";
    private static final String NBT_STAGE = "core_stage";
    private static final int MAX_STAGE = 3;

    public BasicCoreItem(Item.Properties props) {
        super(props.m_41487_(1).setNoRepair());
    }

    public static ItemStack of(CoreType type, int stage) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BASIC_CORE.get());
        if (type != null && stage >= 0 && stage <= 3) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_(NBT_MODEL, type.id);
            tag.m_128405_(NBT_STAGE, stage);
        }
        return stack;
    }

    public static ItemStack storageStage(int stage) {
        return BasicCoreItem.of(CoreType.STORAGE, stage);
    }

    public static ItemStack spatialStage(int stage) {
        return BasicCoreItem.of(CoreType.SPATIAL, stage);
    }

    public static ItemStack energyStage(int stage) {
        return BasicCoreItem.of(CoreType.ENERGY, stage);
    }

    public static ItemStack quantumStage(int stage) {
        return BasicCoreItem.of(CoreType.QUANTUM, stage);
    }

    public static Optional<CoreType> getType(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(NBT_MODEL)) {
            return Optional.empty();
        }
        int cmd = stack.m_41783_().m_128451_(NBT_MODEL);
        return CoreType.byId(cmd);
    }

    public static int getStage(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        return Math.min(stack.m_41783_().m_128451_(NBT_STAGE), 3);
    }

    public static boolean isTyped(ItemStack stack) {
        return BasicCoreItem.getType(stack).isPresent();
    }

    public static boolean isFinalStage(ItemStack stack) {
        return BasicCoreItem.getStage(stack) >= 3;
    }

    public boolean m_142522_(ItemStack stack) {
        return BasicCoreItem.isTyped(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        if (!BasicCoreItem.isTyped(stack)) {
            return 0;
        }
        return Math.round(13.0f * (float)BasicCoreItem.getStage(stack) / 3.0f);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return BasicCoreItem.getType(stack).map(type -> type.getTextColor().m_126665_()).orElse(0xFFFFFF);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!BasicCoreItem.isTyped(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.extendedae_plus.basic_core.untyped").m_130940_(ChatFormatting.GRAY));
            return;
        }
        BasicCoreItem.getType(stack).ifPresent(type -> {
            String finalKey = "item.extendedae_plus." + type.key + "_core";
            tooltip.add((Component)Component.m_237110_((String)"tooltip.extendedae_plus.basic_core.evolving_to", (Object[])new Object[]{Component.m_237115_((String)finalKey).m_130940_(type.getTextColor())}).m_130940_(ChatFormatting.AQUA));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.extendedae_plus.basic_core.progress").m_130940_(ChatFormatting.YELLOW));
            int stage = BasicCoreItem.getStage(stack);
            for (int i = 1; i <= 3; ++i) {
                String key = "item.extendedae_plus.basic_core." + type.key + "." + i;
                ChatFormatting color = i <= stage ? ChatFormatting.GREEN : ChatFormatting.DARK_GRAY;
                String prefix = i <= stage ? "\u2714 " : "\u2718 ";
                tooltip.add((Component)Component.m_237113_((String)prefix).m_130940_(color).m_7220_((Component)Component.m_237115_((String)key)));
            }
            if (stage >= 3) {
                tooltip.add((Component)Component.m_237119_());
                tooltip.add((Component)Component.m_237115_((String)"tooltip.extendedae_plus.basic_core.ready_to_craft").m_130940_(ChatFormatting.GOLD));
            }
        });
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        if (!BasicCoreItem.isTyped(stack)) {
            return Component.m_237115_((String)"item.extendedae_plus.basic_core");
        }
        return BasicCoreItem.getType(stack).map(type -> {
            String key = "item.extendedae_plus.basic_core." + type.key + "." + BasicCoreItem.getStage(stack);
            return Component.m_237115_((String)key).m_130940_(type.getTextColor());
        }).orElseGet(() -> Component.m_237115_((String)"item.extendedae_plus.basic_core"));
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        return BasicCoreItem.isTyped(stack) ? BasicCoreItem.getType(stack).map(t -> t.getRarity(BasicCoreItem.getStage(stack))).orElse(Rarity.COMMON) : Rarity.COMMON;
    }

    public static enum CoreType {
        STORAGE(1, "storage", ChatFormatting.AQUA),
        SPATIAL(2, "spatial", ChatFormatting.YELLOW),
        ENERGY(3, "energy_storage", ChatFormatting.RED),
        QUANTUM(4, "quantum_storage", ChatFormatting.LIGHT_PURPLE);

        public final int id;
        public final String key;
        public final ChatFormatting textColor;

        private CoreType(int id, String key, ChatFormatting textColor) {
            this.id = id;
            this.key = key;
            this.textColor = textColor;
        }

        public static Optional<CoreType> byId(int id) {
            return switch (id) {
                case 1 -> Optional.of(STORAGE);
                case 2 -> Optional.of(SPATIAL);
                case 3 -> Optional.of(ENERGY);
                case 4 -> Optional.of(QUANTUM);
                default -> Optional.empty();
            };
        }

        public ChatFormatting getTextColor() {
            return this.textColor;
        }

        public Rarity getRarity(int stage) {
            return switch (stage) {
                case 1, 2 -> Rarity.UNCOMMON;
                case 3 -> Rarity.EPIC;
                default -> Rarity.COMMON;
            };
        }
    }
}

