/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.items.tools.powered.WirelessCraftingTerminalItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.me.helpers.PlayerSource;
import com.extendedae_plus.util.wireless.WirelessTerminalLocator;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class PickFromWirelessC2SPacket {
    private final BlockPos pos;
    private final Direction face;
    private final Vec3 hitLoc;

    public PickFromWirelessC2SPacket(BlockPos pos, Direction face, Vec3 hitLoc) {
        this.pos = pos;
        this.face = face;
        this.hitLoc = hitLoc;
    }

    public static void encode(PickFromWirelessC2SPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130068_((Enum)msg.face);
        buf.writeDouble(msg.hitLoc.f_82479_);
        buf.writeDouble(msg.hitLoc.f_82480_);
        buf.writeDouble(msg.hitLoc.f_82481_);
    }

    public static PickFromWirelessC2SPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Direction face = (Direction)buf.m_130066_(Direction.class);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new PickFromWirelessC2SPacket(pos, face, new Vec3(x, y, z));
    }

    public static void handle(PickFromWirelessC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            int space;
            boolean placeToMainHand;
            IGrid grid;
            ServerPlayer player = context.getSender();
            if (player == null) return;
            if (player.m_7500_()) {
                return;
            }
            ServerLevel level = player.m_284548_();
            BlockState state = level.m_8055_(msg.pos);
            if (state == null) return;
            if (state.m_60795_()) {
                return;
            }
            WirelessTerminalLocator.LocatedTerminal located = WirelessTerminalLocator.find((Player)player);
            ItemStack terminal = located.stack;
            if (terminal.m_41619_()) {
                return;
            }
            boolean usedWtHost = false;
            String curiosSlotId = located.getCuriosSlotId();
            int curiosIndex = located.getCuriosIndex();
            WTMenuHost wtHost = null;
            if (curiosSlotId != null && curiosIndex >= 0) {
                String current = WUTHandler.getCurrentTerminal((ItemStack)terminal);
                WTDefinition def = (WTDefinition)WUTHandler.wirelessTerminals.get(current);
                if (def == null) return;
                wtHost = def.wTMenuHostFactory().create((Player)player, null, terminal, (p, sub) -> {});
                if (wtHost == null) return;
                IGridNode node = wtHost.getActionableNode();
                if (node == null) return;
                grid = node.getGrid();
                if (grid == null) {
                    return;
                }
                if (!wtHost.drainPower()) {
                    return;
                }
                usedWtHost = true;
            } else {
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem;
                WirelessCraftingTerminalItem c;
                WirelessCraftingTerminalItem wct;
                Item patt0$temp = terminal.m_41720_();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem2 = wct = patt0$temp instanceof WirelessCraftingTerminalItem ? (c = (WirelessCraftingTerminalItem)patt0$temp) : null;
                if (wct != null) {
                    wirelessCraftingTerminalItem = wct;
                } else {
                    Item patt0$temp2 = terminal.m_41720_();
                    if (!(patt0$temp2 instanceof WirelessTerminalItem)) return;
                    WirelessTerminalItem t = (WirelessTerminalItem)patt0$temp2;
                    wirelessCraftingTerminalItem = t;
                }
                WirelessCraftingTerminalItem wt = wirelessCraftingTerminalItem;
                if (wt == null) {
                    return;
                }
                grid = wt.getLinkedGrid(terminal, (Level)level, (Player)player);
                if (grid == null) {
                    return;
                }
                if (!wt.hasPower((Player)player, 0.5, terminal)) {
                    return;
                }
            }
            BlockHitResult bhr = new BlockHitResult(msg.hitLoc, msg.face, msg.pos, true);
            ItemStack picked = state.m_60734_().getCloneItemStack(state, (HitResult)bhr, (BlockGetter)level, msg.pos, (Player)player);
            if (picked.m_41619_()) {
                picked = state.m_60734_().m_5456_().m_7968_();
            }
            if (picked.m_41619_()) {
                return;
            }
            int targetMax = picked.m_41741_();
            AEItemKey targetKey = AEItemKey.of((ItemStack)picked);
            IEnergyService energy = grid.getEnergyService();
            MEStorage storage = grid.getStorageService().getInventory();
            ItemStack inHand = player.m_21205_();
            Inventory inv = player.m_150109_();
            boolean handIsSameItem = !inHand.m_41619_() && AEItemKey.of((ItemStack)inHand).equals((Object)targetKey);
            boolean bl = placeToMainHand = inHand.m_41619_() || handIsSameItem && inHand.m_41613_() < inHand.m_41741_();
            if (placeToMainHand) {
                space = inHand.m_41619_() ? targetMax : Math.min(targetMax, inHand.m_41741_() - inHand.m_41613_());
            } else {
                int free = inv.m_36062_();
                if (free == -1) {
                    return;
                }
                space = targetMax;
            }
            if (space <= 0) {
                return;
            }
            long extracted = StorageHelper.poweredExtraction((IEnergySource)energy, (MEStorage)storage, (AEKey)targetKey, (long)space, (IActionSource)new PlayerSource((Player)player));
            if (extracted <= 0L) {
                return;
            }
            if (placeToMainHand) {
                if (inHand.m_41619_()) {
                    inv.m_6836_(inv.f_35977_, targetKey.toStack((int)extracted));
                } else {
                    int add = (int)Math.min(extracted, (long)(inHand.m_41741_() - inHand.m_41613_()));
                    if (add > 0) {
                        inHand.m_41769_(add);
                        inv.m_6836_(inv.f_35977_, inHand);
                    }
                }
            } else {
                int free = inv.m_36062_();
                if (free == -1) {
                    StorageHelper.poweredInsert((IEnergySource)energy, (MEStorage)storage, (AEKey)targetKey, (long)extracted, (IActionSource)new PlayerSource((Player)player));
                    return;
                }
                inv.m_6836_(free, targetKey.toStack((int)extracted));
            }
            if (!usedWtHost) {
                WirelessCraftingTerminalItem wt2;
                WirelessCraftingTerminalItem c2;
                WirelessCraftingTerminalItem wct2;
                Item patt0$temp = terminal.m_41720_();
                WirelessCraftingTerminalItem wirelessCraftingTerminalItem = wct2 = patt0$temp instanceof WirelessCraftingTerminalItem ? (c2 = (WirelessCraftingTerminalItem)patt0$temp) : null;
                if (wct2 != null) {
                    v4 = wct2;
                } else {
                    Item patt0$temp3 = terminal.m_41720_();
                    if (patt0$temp3 instanceof WirelessTerminalItem) {
                        WirelessTerminalItem t2 = (WirelessTerminalItem)patt0$temp3;
                        v4 = t2;
                    } else {
                        v4 = wt2 = null;
                    }
                }
                if (wt2 != null) {
                    wt2.usePower((Player)player, Math.max(0.5, (double)extracted * 0.05), terminal);
                }
            }
            located.commit();
            player.f_36096_.m_38946_();
        });
        context.setPacketHandled(true);
    }
}

