/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.widgets.SettingToggleButton;
import com.extendedae_plus.util.NumberFormatUtil;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuiUtil {
    private GuiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String getPatternOutputText(ItemStack pattern) {
        if (pattern.m_41619_()) {
            return "";
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)Minecraft.m_91087_().f_91073_, (boolean)false);
        if (details == null || details.getOutputs().length == 0) {
            return "";
        }
        GenericStack out = details.getOutputs()[0];
        long amount = out.amount();
        long perUnit = out.what().getAmountPerUnit();
        if (amount <= 0L || perUnit <= 0L) {
            return "";
        }
        double units = (double)amount / (double)perUnit;
        if (units <= 0.0) {
            return "";
        }
        String autoSuffix = "";
        if (perUnit > 1L) {
            autoSuffix = "B";
        }
        return NumberFormatUtil.formatNumberWithDecimal(units) + autoSuffix;
    }

    public static void drawAmountText(GuiGraphics guiGraphics, Font font, String text, int slotX, int slotY, float scale) {
        if (text.isEmpty()) {
            return;
        }
        int scaledWidth = (int)((float)font.m_92895_(text) * scale);
        int textX = slotX + 16 - scaledWidth;
        int textY = slotY + 11;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280056_(font, text, (int)((float)textX / scale), (int)((float)textY / scale), -1, true);
        guiGraphics.m_280168_().m_85849_();
    }

    private static int withAlpha(int rgb, int alpha255) {
        return (alpha255 & 0xFF) << 24 | rgb & 0xFFFFFF;
    }

    private static int hsvToRgb(float h, float s, float v) {
        float g;
        float r;
        if (s <= 0.0f) {
            int g2 = Math.round(v * 255.0f);
            return g2 << 16 | g2 << 8 | g2;
        }
        float hh = (h - (float)Math.floor(h)) * 6.0f;
        int sector = (int)Math.floor(hh);
        float f = hh - (float)sector;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        float b = switch (sector) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            default -> {
                r = v;
                g = p;
                yield q;
            }
        };
        int ri = Math.round(r * 255.0f);
        int gi = Math.round(g * 255.0f);
        int bi = Math.round(b * 255.0f);
        return ri << 16 | gi << 8 | bi;
    }

    private static int getRainbowRgb() {
        long now = System.currentTimeMillis();
        long rainbowPeriodMs = 4000L;
        float hue = (float)(now % 4000L) / 4000.0f;
        return GuiUtil.hsvToRgb(hue, 1.0f, 1.0f);
    }

    private static void drawSlotBox(GuiGraphics guiGraphics, int sx, int sy, int borderColor, int backgroundColor) {
        guiGraphics.m_280509_(sx - 1, sy - 1, sx + 17, sy, borderColor);
        guiGraphics.m_280509_(sx - 1, sy + 16, sx + 17, sy + 17, borderColor);
        guiGraphics.m_280509_(sx - 1, sy, sx, sy + 16, borderColor);
        guiGraphics.m_280509_(sx + 16, sy, sx + 17, sy + 16, borderColor);
        guiGraphics.m_280509_(sx, sy, sx + 16, sy + 16, backgroundColor);
    }

    public static void drawPatternSlotHighlights(GuiGraphics guiGraphics, List<Slot> slots, Set<ItemStack> matchedStack, Set<PatternContainerRecord> matchedProvider) {
        if (slots == null) {
            return;
        }
        int rainbowRgb = GuiUtil.getRainbowRgb();
        for (Slot slot : slots) {
            int backgroundColor;
            int borderColor;
            if (!(slot instanceof PatternSlot)) continue;
            PatternSlot ps = (PatternSlot)slot;
            int sx = slot.f_40220_;
            int sy = slot.f_40221_;
            boolean isMatchedSlot = matchedStack != null && matchedStack.contains(slot.m_7993_());
            boolean isMatchedProvider = false;
            try {
                PatternContainerRecord container = ps.getMachineInv();
                isMatchedProvider = matchedProvider != null && matchedProvider.contains(container);
            }
            catch (Throwable container) {
                // empty catch block
            }
            if (isMatchedSlot) {
                borderColor = GuiUtil.withAlpha(rainbowRgb, 160);
                backgroundColor = GuiUtil.withAlpha(rainbowRgb, 60);
            } else if (!isMatchedProvider) {
                borderColor = GuiUtil.withAlpha(0xFFFFFF, 64);
                backgroundColor = GuiUtil.withAlpha(0, 24);
            } else {
                borderColor = GuiUtil.withAlpha(0xFFFFFF, 48);
                backgroundColor = GuiUtil.withAlpha(0xFFFFFF, 20);
            }
            GuiUtil.drawSlotBox(guiGraphics, sx, sy, borderColor, backgroundColor);
        }
    }

    public static void drawSlotRainbowHighlight(GuiGraphics guiGraphics, int sx, int sy) {
        int rainbowRgb = GuiUtil.getRainbowRgb();
        int borderColor = GuiUtil.withAlpha(rainbowRgb, 160);
        int backgroundColor = GuiUtil.withAlpha(rainbowRgb, 60);
        GuiUtil.drawSlotBox(guiGraphics, sx, sy, borderColor, backgroundColor);
    }

    public static SettingToggleButton<YesNo> createToggle(boolean initial, Runnable onClick, final Supplier<List<Component>> tooltipSupplier) {
        return new SettingToggleButton<YesNo>(Settings.BLOCKING_MODE, initial ? YesNo.YES : YesNo.NO, (btn, backwards) -> onClick.run()){

            public List<Component> getTooltipMessage() {
                return (List)tooltipSupplier.get();
            }
        };
    }

    public static EditBox createPerProviderLimitInput(Font font, int initialValue, IntConsumer onCommit) {
        EditBox input = new EditBox(font, 0, 0, 28, 12, (Component)Component.m_237113_((String)"Limit"));
        input.m_94199_(6);
        input.m_94144_(String.valueOf(initialValue));
        input.m_94151_(s -> {
            try {
                String sValue;
                String string = sValue = s == null || s.isBlank() ? "0" : s.replaceFirst("^0+(?=.)", "");
                if (!sValue.equals(s)) {
                    input.m_94144_(sValue);
                }
                int limit = Integer.parseInt(sValue);
                onCommit.accept(limit);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        return input;
    }
}

