/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import java.text.DecimalFormat;

public class NumberFormatUtil {
    private NumberFormatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String formatNumber(long number) {
        String formatted;
        int index;
        if (number < 1000L) {
            return String.valueOf(number);
        }
        String[] suffixes = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};
        double value = number;
        for (index = 0; value >= 1000.0 && index < suffixes.length; value /= 1000.0, ++index) {
        }
        if (Math.abs(value - (double)Math.round(value)) < 0.001) {
            formatted = String.valueOf(Math.round(value));
        } else {
            DecimalFormat df = new DecimalFormat("0.00");
            formatted = df.format(value);
        }
        return formatted + suffixes[index - 1];
    }

    public static String formatNumberWithDecimal(double value) {
        if (value < 1000.0) {
            DecimalFormat smallDf = new DecimalFormat("#.##");
            if (value == (double)((long)value)) {
                return String.valueOf((long)value);
            }
            return smallDf.format(value);
        }
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "E", "Z", "Y"};
        String level = "";
        for (int offset = 0; value >= 1000.0 && offset < preFixes.length; value /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(value) + level;
    }

    private static String formatDecimal(double value, String suffix) {
        if (Math.abs(value - (double)Math.round(value)) < 0.001) {
            return String.valueOf(Math.round(value)) + suffix;
        }
        String formatted = String.format("%.1f", value).replaceAll("\\.0$", "");
        return formatted + suffix;
    }
}

