/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.smartDoubling;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.extendedae_plus.api.crafting.ScaledProcessingPattern;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraftforge.fml.loading.LoadingModList;

public final class PatternScaler {
    private static final boolean advAvailable;
    private static final Constructor<?> advCtor;
    private static final Class<?> advIfaceClass;

    private PatternScaler() {
    }

    public static ScaledProcessingPattern createScaled(AEProcessingPattern base, long multiplier) {
        if (advAvailable && advIfaceClass != null && advCtor != null) {
            try {
                if (advIfaceClass.isInstance(base)) {
                    return (ScaledProcessingPattern)advCtor.newInstance(base, multiplier);
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new ScaledProcessingPattern(base, multiplier);
    }

    public static int getComputedMul(AEProcessingPattern proc, int limit) {
        if (limit <= 0) {
            return 0;
        }
        long minMul = Long.MAX_VALUE;
        for (IPatternDetails.IInput input : proc.getInputs()) {
            GenericStack[] possible;
            long amt = input.getMultiplier();
            if (amt <= 0L || (possible = input.getPossibleInputs()) == null || possible.length == 0) continue;
            AEKey key = possible[0].what();
            long unitMul = PatternScaler.getUnitMultiplier(key);
            long limitInUnit = (long)limit * unitMul;
            long allowed = limitInUnit / amt;
            allowed = Math.max(1L, allowed);
            minMul = Math.min(minMul, allowed);
        }
        if (minMul == Long.MAX_VALUE) {
            return 0;
        }
        return minMul > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)minMul;
    }

    private static long getUnitMultiplier(AEKey key) {
        if (key instanceof AEItemKey) {
            return 1L;
        }
        if (key instanceof AEFluidKey) {
            return 1000L;
        }
        try {
            if ("me.ramidzkh.mekae2.ae2.MekanismKey".equals(key.getClass().getName())) {
                return 1000L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1L;
    }

    static {
        boolean available = false;
        Constructor<?> ctor = null;
        Class<?> iface = null;
        try {
            Class<?> clazz = Class.forName("com.extendedae_plus.api.crafting.ScaledProcessingPatternAdv");
            ctor = clazz.getConstructor(AEProcessingPattern.class, Long.TYPE);
            iface = Class.forName("net.pedroksl.advanced_ae.common.patterns.AdvPatternDetails");
            if (LoadingModList.get() != null && LoadingModList.get().getModFileById("advanced_ae") != null) {
                available = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        advAvailable = available;
        advCtor = ctor;
        advIfaceClass = iface;
    }
}

