/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.smartDoubling;

public final class RequestedAmountHolder {
    private static final ThreadLocal<LongStack> HOLDER = ThreadLocal.withInitial(LongStack::new);
    private static final int MAX_DEPTH = 0x1000000;

    private RequestedAmountHolder() {
    }

    public static void push(long v) {
        HOLDER.get().push(v);
    }

    public static void pop() {
        HOLDER.get().pop();
    }

    public static long get() {
        return HOLDER.get().peek();
    }

    public static void clear() {
        HOLDER.get().clear();
    }

    private static final class LongStack {
        private long[] data = new long[16];
        private int size = 0;

        private LongStack() {
        }

        void push(long v) {
            if (this.size == this.data.length) {
                long[] n = new long[this.data.length * 2];
                System.arraycopy(this.data, 0, n, 0, this.data.length);
                this.data = n;
            }
            this.data[this.size++] = v;
        }

        void pop() {
            if (this.size > 0) {
                --this.size;
            }
        }

        long peek() {
            return this.size == 0 ? 0L : this.data[this.size - 1];
        }

        int depth() {
            return this.size;
        }

        void clear() {
            if (this.data.length > 1024) {
                this.data = new long[16];
            }
            this.size = 0;
        }
    }
}

