/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.storage;

import com.extendedae_plus.util.storage.InfinityDataStorage;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class InfinityStorageManager
extends SavedData {
    private final Map<UUID, InfinityDataStorage> cells;

    public InfinityStorageManager() {
        this.cells = new HashMap<UUID, InfinityDataStorage>();
        this.m_77762_();
    }

    private InfinityStorageManager(Map<UUID, InfinityDataStorage> cells) {
        this.cells = cells;
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag cellList = new ListTag();
        for (Map.Entry<UUID, InfinityDataStorage> entry : this.cells.entrySet()) {
            CompoundTag cell = new CompoundTag();
            cell.m_128362_("infinity_cell_uuid", entry.getKey());
            cell.m_128365_("infinity_cell_data", (Tag)entry.getValue().serializeNBT());
            cellList.add((Object)cell);
        }
        nbt.m_128365_("infinity_cell_list", (Tag)cellList);
        nbt.m_128405_("infinity_format_version", 2);
        return nbt;
    }

    public static InfinityStorageManager readNbt(CompoundTag nbt) {
        int version = nbt.m_128441_("infinity_format_version") ? nbt.m_128451_("infinity_format_version") : 1;
        HashMap<UUID, InfinityDataStorage> cells = new HashMap<UUID, InfinityDataStorage>();
        ListTag cellList = nbt.m_128437_("infinity_cell_list", 10);
        for (int i = 0; i < cellList.size(); ++i) {
            CompoundTag cell = cellList.m_128728_(i);
            cells.put(cell.m_128342_("infinity_cell_uuid"), InfinityDataStorage.loadFromNBT(cell.m_128469_("infinity_cell_data")));
        }
        return new InfinityStorageManager(cells);
    }

    public Set<UUID> getAllLoadedUUIDs() {
        return Collections.unmodifiableSet(this.cells.keySet());
    }

    public void updateCell(UUID uuid, InfinityDataStorage infinityDataStorage) {
        this.cells.put(uuid, infinityDataStorage);
        this.m_77762_();
    }

    public void removeCell(UUID uuid) {
        this.cells.remove(uuid);
        this.m_77762_();
    }

    public boolean hasUUID(UUID uuid) {
        return this.cells.containsKey(uuid);
    }

    public InfinityDataStorage getOrCreateCell(UUID uuid) {
        if (!this.cells.containsKey(uuid)) {
            this.updateCell(uuid, new InfinityDataStorage());
        }
        return this.cells.get(uuid);
    }

    public void modifyDisk(UUID uuid, ListTag keys, ListTag amounts, BigInteger itemCount) {
        InfinityDataStorage cellToModify = this.getOrCreateCell(uuid);
        if (keys != null && amounts != null) {
            cellToModify.keys = keys;
            cellToModify.amounts = amounts;
        }
        cellToModify.itemCount = itemCount;
        this.updateCell(uuid, cellToModify);
    }

    public static InfinityStorageManager getInstance(MinecraftServer server) {
        ServerLevel world = server.m_129880_(ServerLevel.f_46428_);
        return (InfinityStorageManager)world.m_8895_().m_164861_(InfinityStorageManager::readNbt, InfinityStorageManager::new, "infinity_biginteger_cells");
    }
}

