/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import com.extendedae_plus.util.NumberFormatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuiUtil {
    private GuiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String getPatternOutputText(ItemStack pattern) {
        if (pattern.m_41619_()) {
            return "";
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)Minecraft.m_91087_().f_91073_, (boolean)false);
        if (details == null || details.getOutputs().length == 0) {
            return "";
        }
        GenericStack out = details.getOutputs()[0];
        long amount = out.amount();
        long perUnit = out.what().getAmountPerUnit();
        if (amount <= 0L || perUnit <= 0L) {
            return "";
        }
        double units = (double)amount / (double)perUnit;
        if (units <= 0.0) {
            return "";
        }
        String autoSuffix = "";
        if (perUnit > 1L) {
            autoSuffix = "B";
        }
        return NumberFormatUtil.formatNumberWithDecimal(units) + autoSuffix;
    }

    public static void drawAmountText(GuiGraphics guiGraphics, Font font, String text, int slotX, int slotY, float scale) {
        if (text.isEmpty()) {
            return;
        }
        int scaledWidth = (int)((float)font.m_92895_(text) * scale);
        int textX = slotX + 16 - scaledWidth;
        int textY = slotY + 11;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280056_(font, text, (int)((float)textX / scale), (int)((float)textY / scale), -1, true);
        guiGraphics.m_280168_().m_85849_();
    }
}

