/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.content;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.crafting.pattern.AEProcessingPattern;
import java.util.Objects;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ScaledProcessingPattern
implements IPatternDetails {
    private final AEProcessingPattern original;
    private final AEItemKey definition;
    private final GenericStack[] sparseInputs;
    private final GenericStack[] sparseOutputs;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] condensedOutputs;

    public ScaledProcessingPattern(AEProcessingPattern original, AEItemKey definition, GenericStack[] sparseInputs, GenericStack[] sparseOutputs, IPatternDetails.IInput[] inputs, GenericStack[] condensedOutputs) {
        this.original = Objects.requireNonNull(original);
        this.definition = Objects.requireNonNull(definition);
        this.sparseInputs = Objects.requireNonNull(sparseInputs);
        this.sparseOutputs = Objects.requireNonNull(sparseOutputs);
        this.inputs = Objects.requireNonNull(inputs);
        this.condensedOutputs = Objects.requireNonNull(condensedOutputs);
    }

    public AEProcessingPattern getOriginal() {
        return this.original;
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public GenericStack[] getOutputs() {
        return this.condensedOutputs;
    }

    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    public GenericStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    public GenericStack getPrimaryOutput() {
        if (this.condensedOutputs.length > 0) {
            return this.condensedOutputs[0];
        }
        return this.original.getPrimaryOutput();
    }

    public boolean supportsPushInputsToExternalInventory() {
        return this.original.supportsPushInputsToExternalInventory();
    }

    public void pushInputsToExternalInventory(KeyCounter[] inputHolder, IPatternDetails.PatternInputSink inputSink) {
        if (this.sparseInputs.length == this.inputs.length) {
            super.pushInputsToExternalInventory(inputHolder, inputSink);
        } else {
            KeyCounter allInputs = new KeyCounter();
            for (KeyCounter keyCounter : inputHolder) {
                allInputs.addAll(keyCounter);
            }
            for (KeyCounter keyCounter : this.sparseInputs) {
                if (keyCounter == null) continue;
                AEKey key = keyCounter.what();
                long amount = keyCounter.amount();
                long available = allInputs.get(key);
                if (available < amount) {
                    throw new RuntimeException("Expected at least %d of %s when pushing scaled pattern, but only %d available".formatted(amount, key, available));
                }
                inputSink.pushInput(key, amount);
                allInputs.remove(key, amount);
            }
        }
    }

    public static final class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        public Input(GenericStack[] template, long multiplier) {
            this.template = template;
            this.multiplier = multiplier;
        }

        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

