/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.integration.jade;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import com.extendedae_plus.content.wireless.WirelessTransceiverBlockEntity;
import com.extendedae_plus.wireless.IWirelessEndpoint;
import com.extendedae_plus.wireless.WirelessMasterRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public enum WirelessTransceiverProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof WirelessTransceiverBlockEntity) {
            long freq;
            ServerLevel level;
            IWirelessEndpoint master;
            WirelessTransceiverBlockEntity blockEntity2 = (WirelessTransceiverBlockEntity)blockEntity;
            data.m_128356_("frequency", blockEntity2.getFrequency());
            data.m_128379_("masterMode", blockEntity2.isMasterMode());
            data.m_128379_("locked", blockEntity2.isLocked());
            IGridNode node = blockEntity2.getGridNode();
            IGrid grid = node == null ? null : node.getGrid();
            boolean networkUsable = false;
            if (grid != null) {
                try {
                    networkUsable = grid.getEnergyService().isNetworkPowered();
                }
                catch (Throwable ignored) {
                    networkUsable = false;
                }
            }
            data.m_128379_("networkUsable", networkUsable);
            if (!blockEntity2.isMasterMode() && (master = WirelessMasterRegistry.get(level = blockEntity2.getServerLevel(), freq = blockEntity2.getFrequency())) != null && !master.isEndpointRemoved()) {
                BlockPos pos = master.m_58899_();
                if (pos != null) {
                    data.m_128356_("masterPos", pos.m_121878_());
                }
                if (master.getServerLevel() != null) {
                    data.m_128359_("masterDim", master.getServerLevel().m_46472_().m_135782_().toString());
                }
            }
        }
    }

    static {
        UID = new ResourceLocation("extendedae_plus", "wireless_transceiver_info");
    }
}

