/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.client.gui;

import appeng.client.Point;
import appeng.client.gui.layout.SlotGridLayout;
import com.extendedae_plus.api.ExPatternPageAccessor;
import com.glodblock.github.extendedae.client.gui.GuiExPatternProvider;
import com.glodblock.github.extendedae.container.ContainerExPatternProvider;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SlotGridLayout.class})
public abstract class SlotGridLayoutMixin {
    @Unique
    private static final int SLOTS_PER_PAGE = 36;

    @Inject(method={"getRowBreakPosition"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void onGetRowBreakPosition(int x, int y, int semanticIdx, int cols, CallbackInfoReturnable<Point> cir) {
        if (cols != 9) {
            return;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof GuiExPatternProvider)) {
            return;
        }
        int currentPage = 0;
        try {
            if (screen instanceof ExPatternPageAccessor) {
                ExPatternPageAccessor accessor = (ExPatternPageAccessor)screen;
                currentPage = accessor.eap$getCurrentPage();
            } else {
                ContainerExPatternProvider menu = (ContainerExPatternProvider)((GuiExPatternProvider)screen).m_6262_();
                Field fieldPage = SlotGridLayoutMixin.eap$findFieldRecursive(menu.getClass(), "page");
                if (fieldPage != null) {
                    fieldPage.setAccessible(true);
                    currentPage = (Integer)fieldPage.get(menu);
                }
            }
        }
        catch (Throwable accessor) {
            // empty catch block
        }
        int slotPage = semanticIdx / 36;
        if (slotPage != currentPage) {
            cir.setReturnValue((Object)new Point(-10000, -10000));
            cir.cancel();
            return;
        }
        int slotInPage = semanticIdx % 36;
        int row = slotInPage / 9;
        int col = slotInPage % 9;
        int targetX = x + col * 18;
        int targetY = y + row * 18;
        cir.setReturnValue((Object)new Point(targetX, targetY));
        cir.cancel();
    }

    @Unique
    private static Field eap$findFieldRecursive(Class<?> cls, String name) {
        for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }
}

