/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

public class NumberFormatUtil {
    private NumberFormatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String formatNumber(long number) {
        if (number < 1000L) {
            return String.valueOf(number);
        }
        if (number < 1000000L) {
            double value = (double)number / 1000.0;
            return NumberFormatUtil.formatDecimal(value, "k");
        }
        double value = (double)number / 1000000.0;
        return NumberFormatUtil.formatDecimal(value, "m");
    }

    public static String formatNumberWithDecimal(double value) {
        if (value < 1000.0) {
            if (value == (double)((long)value)) {
                return String.valueOf((long)value);
            }
            return String.format("%.1f", value).replaceAll("\\.0$", "");
        }
        if (value < 1000000.0) {
            return NumberFormatUtil.formatDecimal(value / 1000.0, "k");
        }
        return NumberFormatUtil.formatDecimal(value / 1000000.0, "m");
    }

    private static String formatDecimal(double value, String suffix) {
        if (Math.abs(value - (double)Math.round(value)) < 0.001) {
            return String.valueOf(Math.round(value)) + suffix;
        }
        String formatted = String.format("%.1f", value).replaceAll("\\.0$", "");
        return formatted + suffix;
    }
}

