/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.extendedae_plus.api.SmartDoublingAwarePattern;
import com.extendedae_plus.content.ScaledProcessingPattern;

public final class PatternScaler {
    private PatternScaler() {
    }

    public static ScaledProcessingPattern scale(AEProcessingPattern base, AEKey target, long requestedAmount) {
        long amt;
        int i;
        SmartDoublingAwarePattern aware;
        if (base == null) {
            throw new IllegalArgumentException("base");
        }
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (base instanceof SmartDoublingAwarePattern && !(aware = (SmartDoublingAwarePattern)base).eap$allowScaling()) {
            return null;
        }
        GenericStack[] baseSparseInputs = base.getSparseInputs();
        GenericStack[] baseSparseOutputs = base.getSparseOutputs();
        IPatternDetails.IInput[] baseInputs = base.getInputs();
        GenericStack[] baseOutputs = base.getOutputs();
        int targetOutIndex = -1;
        for (i = 0; i < baseOutputs.length; ++i) {
            GenericStack out = baseOutputs[i];
            if (out == null || target == null || out.what() == null || !out.what().equals(target)) continue;
            targetOutIndex = i;
            break;
        }
        if (targetOutIndex == -1) {
            for (i = 0; i < baseOutputs.length; ++i) {
                if (baseOutputs[i] == null) continue;
                targetOutIndex = i;
                break;
            }
        }
        if (targetOutIndex == -1 && baseOutputs.length > 0) {
            targetOutIndex = 0;
        }
        long perOperationTarget = 1L;
        if (targetOutIndex >= 0 && baseOutputs[targetOutIndex] != null && (amt = baseOutputs[targetOutIndex].amount()) > 0L) {
            perOperationTarget = amt;
        }
        long multiplier = 1L;
        if (requestedAmount > 0L) {
            long needed = requestedAmount / perOperationTarget + (long)(requestedAmount % perOperationTarget == 0L ? 0 : 1);
            multiplier = needed <= 1L ? 1L : needed;
        }
        IPatternDetails.IInput[] scaledInputs = new IPatternDetails.IInput[baseInputs.length];
        for (int i2 = 0; i2 < baseInputs.length; ++i2) {
            IPatternDetails.IInput in = baseInputs[i2];
            GenericStack[] template = in.getPossibleInputs();
            GenericStack[] scaledTemplates = new GenericStack[template.length];
            for (int j = 0; j < template.length; ++j) {
                scaledTemplates[j] = new GenericStack(template[j].what(), template[j].amount());
            }
            scaledInputs[i2] = new ScaledProcessingPattern.Input(scaledTemplates, in.getMultiplier() * multiplier);
        }
        GenericStack[] scaledCondensedOutputs = new GenericStack[baseOutputs.length];
        for (int i3 = 0; i3 < baseOutputs.length; ++i3) {
            GenericStack out = baseOutputs[i3];
            if (out == null) continue;
            scaledCondensedOutputs[i3] = new GenericStack(out.what(), out.amount() * multiplier);
        }
        GenericStack[] scaledSparseInputs = new GenericStack[baseSparseInputs.length];
        for (int i4 = 0; i4 < baseSparseInputs.length; ++i4) {
            GenericStack in = baseSparseInputs[i4];
            if (in == null) continue;
            scaledSparseInputs[i4] = new GenericStack(in.what(), in.amount() * multiplier);
        }
        GenericStack[] scaledSparseOutputs = new GenericStack[baseSparseOutputs.length];
        for (int i5 = 0; i5 < baseSparseOutputs.length; ++i5) {
            GenericStack out = baseSparseOutputs[i5];
            if (out == null) continue;
            scaledSparseOutputs[i5] = new GenericStack(out.what(), out.amount() * multiplier);
        }
        return new ScaledProcessingPattern(base, base.getDefinition(), scaledSparseInputs, scaledSparseOutputs, scaledInputs, scaledCondensedOutputs);
    }
}

