/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.ae.screen;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.CommonButtons;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.util.Platform;
import com.extendedae_plus.ae.menu.EntitySpeedTickerMenu;
import com.extendedae_plus.init.ModNetwork;
import com.extendedae_plus.network.ToggleEntityTickerC2SPacket;
import com.extendedae_plus.util.entitySpeed.PowerUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class EntitySpeedTickerScreen<C extends EntitySpeedTickerMenu>
extends UpgradeableScreen<C> {
    private boolean eap$entitySpeedTickerEnabled = false;
    private boolean eap$redstoneControlEnabled = false;
    private final SettingToggleButton<YesNo> eap$entitySpeedTickerToggle;
    private final SettingToggleButton<YesNo> eap$redstoneControlToggle;

    public EntitySpeedTickerScreen(final EntitySpeedTickerMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)CommonButtons.togglePowerUnit());
        this.eap$entitySpeedTickerEnabled = menu.getAccelerateEnabled();
        this.eap$redstoneControlEnabled = menu.getRedstoneControlEnabled();
        this.eap$entitySpeedTickerToggle = new SettingToggleButton<YesNo>(Settings.BLOCKING_MODE, this.eap$entitySpeedTickerEnabled ? YesNo.YES : YesNo.NO, (btn, backwards) -> ModNetwork.CHANNEL.sendToServer((Object)new ToggleEntityTickerC2SPacket(ToggleEntityTickerC2SPacket.Setting.accelerateEnabled))){

            public List<Component> getTooltipMessage() {
                if (menu.targetBlacklisted) {
                    return List.of(Component.m_237115_((String)"extendedae_plus.gui.entity_acceleration.title"), Component.m_237115_((String)"extendedae_plus.gui.entity_acceleration.blacklisted"));
                }
                boolean enabled = EntitySpeedTickerScreen.this.eap$entitySpeedTickerEnabled;
                return List.of(Component.m_237115_((String)"extendedae_plus.gui.entity_acceleration.title"), enabled ? Component.m_237115_((String)"extendedae_plus.gui.entity_acceleration.enabled") : Component.m_237115_((String)"extendedae_plus.gui.entity_acceleration.disabled"));
            }

            protected Icon getIcon() {
                if (menu.targetBlacklisted) {
                    return Icon.INVALID;
                }
                return this.getCurrentValue() == YesNo.YES ? Icon.VALID : Icon.INVALID;
            }
        };
        this.eap$entitySpeedTickerToggle.set((Enum)(this.eap$entitySpeedTickerEnabled ? YesNo.YES : YesNo.NO));
        this.addToLeftToolbar((Button)this.eap$entitySpeedTickerToggle);
        this.eap$redstoneControlToggle = new SettingToggleButton<YesNo>(Settings.BLOCKING_MODE, this.eap$redstoneControlEnabled ? YesNo.YES : YesNo.NO, (btn, backwards) -> ModNetwork.CHANNEL.sendToServer((Object)new ToggleEntityTickerC2SPacket(ToggleEntityTickerC2SPacket.Setting.redstoneControlEnabled))){

            public List<Component> getTooltipMessage() {
                boolean enabled = EntitySpeedTickerScreen.this.eap$redstoneControlEnabled;
                return List.of(Component.m_237115_((String)"extendedae_plus.gui.redstone_control.title"), enabled ? Component.m_237115_((String)"extendedae_plus.gui.redstone_control.enabled") : Component.m_237115_((String)"extendedae_plus.gui.redstone_control.disabled"));
            }

            protected Icon getIcon() {
                return this.getCurrentValue() == YesNo.YES ? Icon.REDSTONE_LOW : Icon.REDSTONE_IGNORE;
            }
        };
        this.eap$redstoneControlToggle.set((Enum)(this.eap$redstoneControlEnabled ? YesNo.YES : YesNo.NO));
        this.addToLeftToolbar((Button)this.eap$redstoneControlToggle);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        if (this.eap$entitySpeedTickerToggle != null && this.f_97732_ != null) {
            this.eap$entitySpeedTickerEnabled = ((EntitySpeedTickerMenu)this.f_97732_).getAccelerateEnabled();
            this.eap$entitySpeedTickerToggle.set((Enum)(((EntitySpeedTickerMenu)this.f_97732_).targetBlacklisted ? YesNo.NO : (this.eap$entitySpeedTickerEnabled ? YesNo.YES : YesNo.NO)));
            boolean bl = this.eap$entitySpeedTickerToggle.f_93623_ = !((EntitySpeedTickerMenu)this.f_97732_).targetBlacklisted;
        }
        if (this.eap$redstoneControlToggle != null && this.f_97732_ != null) {
            this.eap$redstoneControlEnabled = ((EntitySpeedTickerMenu)this.f_97732_).getRedstoneControlEnabled();
            this.eap$redstoneControlToggle.set((Enum)(this.eap$redstoneControlEnabled ? YesNo.YES : YesNo.NO));
        }
        this.textData();
    }

    public void refreshGui() {
        this.textData();
    }

    private void textData() {
        HashMap<String, Object> textContents = new HashMap<String, Object>();
        if (((EntitySpeedTickerMenu)this.m_6262_()).targetBlacklisted || !((EntitySpeedTickerMenu)this.m_6262_()).getAccelerateEnabled()) {
            textContents.put("enable", Component.m_237115_((String)"screen.extendedae_plus.entity_speed_ticker.enable"));
            textContents.put("speed", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.speed", (Object[])new Object[]{0}));
            textContents.put("energy", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.energy", (Object[])new Object[]{Platform.formatPower((double)0.0, (boolean)false)}));
            textContents.put("power_ratio", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.power_ratio", (Object[])new Object[]{PowerUtils.formatPercentage(0.0)}));
            textContents.put("multiplier", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.multiplier", (Object[])new Object[]{String.format("%.2fx", 0.0)}));
        } else {
            int energyCardCount = ((EntitySpeedTickerMenu)this.m_6262_()).energyCardCount;
            double multiplier = ((EntitySpeedTickerMenu)this.m_6262_()).multiplier;
            int effectiveSpeed = ((EntitySpeedTickerMenu)this.m_6262_()).effectiveSpeed;
            double finalPower = PowerUtils.getCachedPower(effectiveSpeed, energyCardCount);
            double remainingRatio = PowerUtils.getCachedRatio(energyCardCount);
            textContents.put("enable", ((EntitySpeedTickerMenu)this.m_6262_()).networkEnergySufficient ? null : Component.m_237115_((String)"screen.extendedae_plus.entity_speed_ticker.warning_network_energy_insufficient"));
            textContents.put("speed", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.speed", (Object[])new Object[]{effectiveSpeed}));
            textContents.put("energy", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.energy", (Object[])new Object[]{Platform.formatPower((double)finalPower, (boolean)false)}));
            textContents.put("power_ratio", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.power_ratio", (Object[])new Object[]{PowerUtils.formatPercentage(remainingRatio)}));
            textContents.put("multiplier", Component.m_237110_((String)"screen.extendedae_plus.entity_speed_ticker.multiplier", (Object[])new Object[]{String.format("%.2fx", multiplier)}));
        }
        textContents.forEach((x$0, x$1) -> this.setTextContent((String)x$0, (Component)x$1));
    }
}

