/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.mixin.ae2.parts.storagebus;

import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.parts.AEBasePart;
import appeng.parts.storagebus.StorageBusPart;
import com.extendedae_plus.ae.wireless.WirelessSlaveLink;
import com.extendedae_plus.ae.wireless.endpoint.GenericNodeEndpointImpl;
import com.extendedae_plus.api.bridge.IInterfaceWirelessLinkBridge;
import com.extendedae_plus.init.ModItems;
import com.extendedae_plus.items.materials.ChannelCardItem;
import com.extendedae_plus.util.Logger;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StorageBusPart.class}, remap=false)
public abstract class StorageBusPartChannelCardMixin
implements IInterfaceWirelessLinkBridge,
IUpgradeableObject {
    @Unique
    private WirelessSlaveLink eap$link;
    @Unique
    private long eap$lastChannel = -1L;
    @Unique
    private boolean eap$clientConnected = false;

    @Inject(method={"upgradesChanged"}, at={@At(value="TAIL")})
    private void eap$onUpgradesChanged(CallbackInfo ci) {
        if (!((AEBasePart)this).isClientSide()) {
            this.eap$initializeChannelLink();
        }
    }

    @Inject(method={"onMainNodeStateChanged"}, at={@At(value="TAIL")})
    private void eap$onMainNodeStateChanged(IGridNodeListener.State reason, CallbackInfo ci) {
        if (reason == IGridNodeListener.State.GRID_BOOT && !((AEBasePart)this).isClientSide()) {
            this.eap$initializeChannelLink();
        }
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eap$afterReadFromNBT(CompoundTag extra, CallbackInfo ci) {
        if (!((AEBasePart)this).isClientSide()) {
            this.eap$lastChannel = -1L;
            this.eap$initializeChannelLink();
        }
    }

    @Override
    @Unique
    public void eap$initializeChannelLink() {
        if (((AEBasePart)this).isClientSide()) {
            return;
        }
        try {
            IUpgradeInventory inv = this.getUpgrades();
            long channel = 0L;
            UUID ownerUUID = null;
            boolean found = false;
            for (ItemStack stack : inv) {
                if (stack.m_41619_() || stack.m_41720_() != ModItems.CHANNEL_CARD.get()) continue;
                channel = ChannelCardItem.getChannel(stack);
                ownerUUID = ChannelCardItem.getOwnerUUID(stack);
                found = true;
                break;
            }
            if (this.eap$lastChannel == channel) {
                return;
            }
            this.eap$lastChannel = channel;
            Logger.EAP$LOGGER.debug("[\u670d\u52a1\u7aef] StorageBus \u521d\u59cb\u5316\u9891\u9053\u94fe\u63a5: found={}, channel={}", (Object)found, (Object)channel);
            if (!found) {
                if (this.eap$link != null) {
                    this.eap$link.setFrequency(0L);
                    this.eap$link.updateStatus();
                    Logger.EAP$LOGGER.debug("[\u670d\u52a1\u7aef] StorageBus \u65ad\u5f00\u9891\u9053\u94fe\u63a5");
                    ((AEBasePart)this).getHost().markForUpdate();
                }
                return;
            }
            if (this.eap$link == null) {
                GenericNodeEndpointImpl endpoint = new GenericNodeEndpointImpl(() -> ((AEBasePart)this).getHost().getBlockEntity(), () -> ((IActionHost)this).getActionableNode());
                this.eap$link = new WirelessSlaveLink(endpoint);
                Logger.EAP$LOGGER.debug("[\u670d\u52a1\u7aef] StorageBus \u521b\u5efa\u65b0\u7684\u65e0\u7ebf\u94fe\u63a5");
            }
            this.eap$link.setPlacerId(ownerUUID);
            this.eap$link.setFrequency(channel);
            this.eap$link.updateStatus();
            Logger.EAP$LOGGER.debug("[\u670d\u52a1\u7aef] StorageBus \u8bbe\u7f6e\u9891\u9053: {}, \u8fde\u63a5\u72b6\u6001: {}", (Object)channel, (Object)this.eap$link.isConnected());
            ((AEBasePart)this).getHost().markForUpdate();
        }
        catch (Exception e) {
            Logger.EAP$LOGGER.error("[\u670d\u52a1\u7aef] StorageBus \u521d\u59cb\u5316\u9891\u9053\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void eap$updateWirelessLink() {
        if (this.eap$link != null) {
            this.eap$link.updateStatus();
        }
    }

    @Override
    public boolean eap$isWirelessConnected() {
        if (((AEBasePart)this).isClientSide()) {
            return this.eap$clientConnected;
        }
        return this.eap$link != null && this.eap$link.isConnected();
    }

    @Override
    public void eap$setClientWirelessState(boolean connected) {
        this.eap$clientConnected = connected;
    }
}

