/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.network.meInterface;

import appeng.api.stacks.GenericStack;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.InterfaceLogicHost;
import appeng.menu.implementations.InterfaceMenu;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class InterfaceAdjustConfigAmountC2SPacket {
    private final int slotIndex;
    private final boolean divide;
    private final int factor;

    public InterfaceAdjustConfigAmountC2SPacket(int slotIndex, boolean divide, int factor) {
        this.slotIndex = slotIndex;
        this.divide = divide;
        this.factor = factor;
    }

    public static void encode(InterfaceAdjustConfigAmountC2SPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.slotIndex);
        buf.writeBoolean(msg.divide);
        buf.m_130130_(msg.factor);
    }

    public static InterfaceAdjustConfigAmountC2SPacket decode(FriendlyByteBuf buf) {
        int slot = buf.m_130242_();
        boolean div = buf.readBoolean();
        int factor = buf.m_130242_();
        return new InterfaceAdjustConfigAmountC2SPacket(slot, div, factor);
    }

    public static void handle(InterfaceAdjustConfigAmountC2SPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            InterfaceMenu menu = null;
            ContainerExInterface exMenu = null;
            AbstractContainerMenu patt0$temp = player.f_36096_;
            if (patt0$temp instanceof InterfaceMenu) {
                InterfaceMenu im;
                menu = im = (InterfaceMenu)patt0$temp;
            } else {
                AbstractContainerMenu patt1$temp = player.f_36096_;
                if (patt1$temp instanceof ContainerExInterface) {
                    ContainerExInterface cem;
                    exMenu = cem = (ContainerExInterface)patt1$temp;
                } else {
                    return;
                }
            }
            try {
                InterfaceLogic logic = (menu != null ? (InterfaceLogicHost)menu.getHost() : (InterfaceLogicHost)exMenu.getHost()).getInterfaceLogic();
                ConfigInventory config = logic.getConfig();
                if (msg.slotIndex == -1) {
                    int size = config.size();
                    for (int idx = 0; idx < size; ++idx) {
                        long next;
                        GenericStack st = config.getStack(idx);
                        if (st == null) continue;
                        long current = st.amount();
                        int factor = Math.max(1, msg.factor);
                        if (msg.divide) {
                            if (factor <= 1 || current % (long)factor != 0L) continue;
                            next = current / (long)factor;
                            if (next < 1L) {
                                next = 1L;
                            }
                        } else {
                            if (factor <= 1) continue;
                            next = current * (long)factor;
                            if (next < 1L) {
                                next = 1L;
                            }
                        }
                        GenericStack newStack = new GenericStack(st.what(), next);
                        config.setStack(idx, newStack);
                    }
                } else {
                    long next;
                    GenericStack stack = config.getStack(msg.slotIndex);
                    if (stack == null) {
                        return;
                    }
                    long current = stack.amount();
                    int factor = Math.max(1, msg.factor);
                    if (msg.divide) {
                        if (factor <= 1) {
                            return;
                        }
                        if (current % (long)factor != 0L) {
                            return;
                        }
                        next = current / (long)factor;
                        if (next < 1L) {
                            next = 1L;
                        }
                    } else {
                        if (factor <= 1) {
                            return;
                        }
                        next = current * (long)factor;
                        if (next < 1L) {
                            next = 1L;
                        }
                    }
                    GenericStack newStack = new GenericStack(stack.what(), next);
                    config.setStack(msg.slotIndex, newStack);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ctx.setPacketHandled(true);
    }
}

