/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util;

import com.extendedae_plus.gui.NewIcon;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public final class ScaleButtonHelper {
    private ScaleButtonHelper() {
    }

    public static ScaleButtonSet createButtons(BiConsumer<Boolean, Integer> handler) {
        ActionEPPButton div2 = new ActionEPPButton(b -> handler.accept(true, 2), NewIcon.DIVIDE2);
        ActionEPPButton x2 = new ActionEPPButton(b -> handler.accept(false, 2), NewIcon.MULTIPLY2);
        ActionEPPButton div5 = new ActionEPPButton(b -> handler.accept(true, 5), NewIcon.DIVIDE5);
        ActionEPPButton x5 = new ActionEPPButton(b -> handler.accept(false, 5), NewIcon.MULTIPLY5);
        ActionEPPButton div10 = new ActionEPPButton(b -> handler.accept(true, 10), NewIcon.DIVIDE10);
        ActionEPPButton x10 = new ActionEPPButton(b -> handler.accept(false, 10), NewIcon.MULTIPLY10);
        for (ActionEPPButton b2 : List.of(x2, div2, x5, div5, x10, div10)) {
            b2.setVisibility(true);
            b2.m_257544_(null);
        }
        return new ScaleButtonSet(x2, div2, x5, div5, x10, div10);
    }

    public static List<ActionEPPButton> all(ScaleButtonSet set) {
        return new ArrayList<ActionEPPButton>(List.of(set.divide2(), set.multiply2(), set.divide5(), set.multiply5(), set.divide10(), set.multiply10()));
    }

    public static void layoutButtons(ScaleButtonSet set, int baseX, int baseY, int spacing, Side side) {
        int bx = baseX + (side == Side.LEFT ? -1 : 1);
        int by = baseY;
        set.divide2().m_252865_(bx);
        set.divide2().m_253211_(by);
        set.multiply2().m_252865_(bx);
        set.multiply2().m_253211_(by + spacing);
        set.divide5().m_252865_(bx);
        set.divide5().m_253211_(by + spacing * 2);
        set.multiply5().m_252865_(bx);
        set.multiply5().m_253211_(by + spacing * 3);
        set.divide10().m_252865_(bx);
        set.divide10().m_253211_(by + spacing * 4);
        set.multiply10().m_252865_(bx);
        set.multiply10().m_253211_(by + spacing * 5);
    }

    public static List<ActionEPPButton> createAndLayout(int baseX, int baseY, int spacing, Side side, BiConsumer<Boolean, Integer> handler) {
        ScaleButtonSet set = ScaleButtonHelper.createButtons(handler);
        ScaleButtonHelper.layoutButtons(set, baseX, baseY, spacing, side);
        return ScaleButtonHelper.all(set);
    }

    public record ScaleButtonSet(ActionEPPButton multiply2, ActionEPPButton divide2, ActionEPPButton multiply5, ActionEPPButton divide5, ActionEPPButton multiply10, ActionEPPButton divide10) {
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

