/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.entitySpeed;

import com.extendedae_plus.config.ModConfig;
import com.extendedae_plus.util.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ConfigParsingUtils {
    private static final Supplier<String[]> BLACKLIST_SUPPLIER = () -> ModConfig.INSTANCE.entityTickerBlackList;
    private static final Supplier<String[]> MULTIPLIERS_SUPPLIER = () -> ModConfig.INSTANCE.entityTickerMultipliers;
    private static volatile Map<String, Pattern> cachedBlacklist = null;
    private static volatile Map<String, MultiplierEntry> cachedMultiplierEntries = null;
    private static volatile String[] cachedBlacklistSourceSnapshot = null;
    private static volatile String[] cachedMultiplierSourceSnapshot = null;
    private static volatile Map<String, Boolean> blacklistResultCache = new HashMap<String, Boolean>();
    private static volatile Map<String, Double> multiplierResultCache = new HashMap<String, Double>();
    private static final Object CACHE_LOCK = new Object();

    private ConfigParsingUtils() {
    }

    public static Pattern compilePattern(String raw) {
        if (raw == null || raw.trim().isEmpty()) {
            Logger.EAP$LOGGER.warn("Invalid pattern: {}", (Object)raw);
            throw new IllegalArgumentException("Pattern is null or empty");
        }
        if ((raw = raw.trim()).contains(".*") || raw.matches(".*[\\[\\(\\+\\{\\\\].*")) {
            try {
                return Pattern.compile("^" + raw + "$");
            }
            catch (PatternSyntaxException e) {
                Logger.EAP$LOGGER.warn("Failed to compile regex pattern '{}': {}", (Object)raw, (Object)e.getMessage());
            }
        }
        if (raw.contains("*") || raw.contains("?")) {
            StringBuilder sb = new StringBuilder("^");
            block6: for (char c : raw.toCharArray()) {
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block6;
                    }
                    case '?': {
                        sb.append('.');
                        continue block6;
                    }
                    default: {
                        if (".\\+[]{}()^$|".indexOf(c) >= 0) {
                            sb.append('\\');
                        }
                        sb.append(c);
                    }
                }
            }
            sb.append('$');
            return Pattern.compile(sb.toString());
        }
        return Pattern.compile("^" + Pattern.quote(raw) + "$");
    }

    public static MultiplierEntry parseMultiplierEntry(String entry) {
        double multiplier;
        if (entry == null || entry.trim().isEmpty()) {
            return null;
        }
        String[] parts = entry.trim().split("\\s+");
        if (parts.length < 2) {
            Logger.EAP$LOGGER.warn("Invalid multiplier entry: {}", (Object)entry);
            return null;
        }
        String key = parts[0];
        String val = parts[1].toLowerCase();
        if (val.endsWith("x")) {
            val = val.substring(0, val.length() - 1);
        }
        try {
            multiplier = Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            Logger.EAP$LOGGER.warn("Invalid multiplier value in '{}': {}", (Object)entry, (Object)val);
            return null;
        }
        try {
            Pattern pattern = ConfigParsingUtils.compilePattern(key);
            return new MultiplierEntry(pattern, multiplier);
        }
        catch (IllegalArgumentException e) {
            Logger.EAP$LOGGER.warn("Failed to compile pattern in '{}': {}", (Object)entry, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isBlockBlacklisted(String blockId) {
        if (blockId == null || BLACKLIST_SUPPLIER.get() == null || BLACKLIST_SUPPLIER.get().length == 0) {
            return false;
        }
        return blacklistResultCache.computeIfAbsent(blockId, id -> ConfigParsingUtils.getCachedBlacklist().values().stream().anyMatch(p -> p.matcher((CharSequence)id).matches()));
    }

    public static double getMultiplierForBlock(String blockId) {
        if (blockId == null || MULTIPLIERS_SUPPLIER.get() == null || MULTIPLIERS_SUPPLIER.get().length == 0) {
            return 1.0;
        }
        return multiplierResultCache.computeIfAbsent(blockId, id -> {
            double maxMultiplier = 1.0;
            for (MultiplierEntry me : ConfigParsingUtils.getCachedMultiplierEntries().values()) {
                if (!me.pattern.matcher((CharSequence)id).matches()) continue;
                maxMultiplier = Math.max(maxMultiplier, me.multiplier);
            }
            return maxMultiplier;
        });
    }

    public static Map<String, Pattern> compilePatterns(String[] raw) {
        HashMap<String, Pattern> out = new HashMap<String, Pattern>();
        if (raw == null) {
            return out;
        }
        for (String s : raw) {
            if (s == null || s.trim().isEmpty()) continue;
            String trimmed = s.trim();
            try {
                out.put(trimmed, ConfigParsingUtils.compilePattern(trimmed));
            }
            catch (IllegalArgumentException e) {
                Logger.EAP$LOGGER.warn("Failed to compile pattern '{}': {}", (Object)trimmed, (Object)e.getMessage());
            }
        }
        return out;
    }

    public static Map<String, MultiplierEntry> parseMultiplierList(String[] raw) {
        HashMap<String, MultiplierEntry> out = new HashMap<String, MultiplierEntry>();
        if (raw == null) {
            return out;
        }
        for (String s : raw) {
            String trimmed;
            MultiplierEntry me;
            if (s == null || s.trim().isEmpty() || (me = ConfigParsingUtils.parseMultiplierEntry(trimmed = s.trim())) == null) continue;
            out.put(trimmed, me);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Pattern> getCachedBlacklist() {
        Object[] source = BLACKLIST_SUPPLIER.get();
        if (cachedBlacklist != null && Arrays.equals(cachedBlacklistSourceSnapshot, source)) {
            return Collections.unmodifiableMap(cachedBlacklist);
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (cachedBlacklist == null || !Arrays.equals(cachedBlacklistSourceSnapshot, source)) {
                cachedBlacklist = ConfigParsingUtils.compilePatterns((String[])source);
                cachedBlacklistSourceSnapshot = source == null ? new String[]{} : (String[])source.clone();
            }
            return Collections.unmodifiableMap(cachedBlacklist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, MultiplierEntry> getCachedMultiplierEntries() {
        Object[] source = MULTIPLIERS_SUPPLIER.get();
        if (cachedMultiplierEntries != null && Arrays.equals(cachedMultiplierSourceSnapshot, source)) {
            return Collections.unmodifiableMap(cachedMultiplierEntries);
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (cachedMultiplierEntries == null || !Arrays.equals(cachedMultiplierSourceSnapshot, source)) {
                cachedMultiplierEntries = ConfigParsingUtils.parseMultiplierList((String[])source);
                cachedMultiplierSourceSnapshot = source == null ? new String[]{} : (String[])source.clone();
            }
            return Collections.unmodifiableMap(cachedMultiplierEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            cachedBlacklist = null;
            cachedMultiplierEntries = null;
            cachedBlacklistSourceSnapshot = null;
            cachedMultiplierSourceSnapshot = null;
            blacklistResultCache.clear();
            multiplierResultCache.clear();
        }
    }

    static {
        ConfigParsingUtils.reload();
    }

    public record MultiplierEntry(Pattern pattern, double multiplier) {
    }
}

