/*
 * Decompiled with CFR 0.152.
 */
package com.extendedae_plus.util.wireless;

import appeng.items.tools.powered.WirelessCraftingTerminalItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public final class WirelessTerminalLocator {
    private WirelessTerminalLocator() {
    }

    public static LocatedTerminal find(Player player) {
        if (player == null) {
            return new LocatedTerminal(ItemStack.f_41583_, s -> {});
        }
        ItemStack main = player.m_21205_();
        if (!main.m_41619_() && (main.m_41720_() instanceof WirelessCraftingTerminalItem || main.m_41720_() instanceof WirelessTerminalItem)) {
            return new LocatedTerminal(main, ns -> player.m_21008_(InteractionHand.MAIN_HAND, ns), -1, InteractionHand.MAIN_HAND);
        }
        ItemStack off = player.m_21206_();
        if (!off.m_41619_() && (off.m_41720_() instanceof WirelessCraftingTerminalItem || off.m_41720_() instanceof WirelessTerminalItem)) {
            return new LocatedTerminal(off, ns -> player.m_21008_(InteractionHand.OFF_HAND, ns), -1, InteractionHand.OFF_HAND);
        }
        Inventory inv = player.m_150109_();
        int size = inv.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack st = inv.m_8020_(i);
            if (st.m_41619_() || !(st.m_41720_() instanceof WirelessCraftingTerminalItem) && !(st.m_41720_() instanceof WirelessTerminalItem)) continue;
            int slot = i;
            return new LocatedTerminal(st, ns -> inv.m_6836_(slot, ns), slot);
        }
        if (ModList.get().isLoaded("curios")) {
            try {
                Optional resolved = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
                if (resolved.isPresent()) {
                    ICuriosItemHandler handler = (ICuriosItemHandler)resolved.get();
                    for (Map.Entry entry : handler.getCurios().entrySet()) {
                        String slotId = (String)entry.getKey();
                        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                        IDynamicStackHandler stacks = stacksHandler.getStacks();
                        int slots = stacks.getSlots();
                        for (int i = 0; i < slots; ++i) {
                            ItemStack st = stacks.getStackInSlot(i);
                            if (st.m_41619_() || !(st.m_41720_() instanceof WirelessCraftingTerminalItem) && !(st.m_41720_() instanceof WirelessTerminalItem)) continue;
                            int slot = i;
                            Consumer<ItemStack> setter = ns -> stacks.setStackInSlot(slot, ns);
                            return new LocatedTerminal(st, setter, -1, null, slotId, slot);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new LocatedTerminal(ItemStack.f_41583_, s -> {}, -1, null);
    }

    public static final class LocatedTerminal {
        public final ItemStack stack;
        private final Consumer<ItemStack> setter;
        private final int slotIndex;
        private final InteractionHand hand;
        private final String curiosSlotId;
        private final int curiosIndex;

        public LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter) {
            this(stack, setter, -1, null, null, -1);
        }

        public LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter, int slotIndex) {
            this(stack, setter, slotIndex, null, null, -1);
        }

        public LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter, int slotIndex, InteractionHand hand) {
            this(stack, setter, slotIndex, hand, null, -1);
        }

        public LocatedTerminal(ItemStack stack, Consumer<ItemStack> setter, int slotIndex, InteractionHand hand, String curiosSlotId, int curiosIndex) {
            this.stack = stack;
            this.setter = setter;
            this.slotIndex = slotIndex;
            this.hand = hand;
            this.curiosSlotId = curiosSlotId;
            this.curiosIndex = curiosIndex;
        }

        public void set(ItemStack newStack) {
            this.setter.accept(newStack);
        }

        public void commit() {
            this.setter.accept(this.stack);
        }

        public boolean isEmpty() {
            return this.stack == null || this.stack.m_41619_();
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        public String getCuriosSlotId() {
            return this.curiosSlotId;
        }

        public int getCuriosIndex() {
            return this.curiosIndex;
        }
    }
}

