/*
 * Decompiled with CFR 0.152.
 */
package tw.iehow.mixin;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tw.iehow.data.PortalData;
import tw.iehow.data.PortalManager;
import tw.iehow.teleport.TeleportHandler;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Unique
    private static final Map<UUID, Boolean> playersInPortal = new HashMap<UUID, Boolean>();

    public ServerPlayerEntityMixin(class_1937 world, GameProfile gameProfile) {
        super(world, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (player.field_6012 % 5 == 0) {
            this.checkPortalCollision(player);
        }
    }

    @Unique
    private void checkPortalCollision(class_3222 player) {
        class_2338 playerPos = player.method_24515();
        String currentDimension = player.method_51469().method_27983().method_29177().toString();
        UUID playerId = player.method_5667();
        boolean isInAnyPortal = false;
        for (PortalData portal : PortalManager.getAllPortals()) {
            if (!portal.positions.dimension.equals(currentDimension) || !this.isPlayerInPortalArea(playerPos, portal.positions)) continue;
            isInAnyPortal = true;
            if (playersInPortal.getOrDefault(playerId, false).booleanValue()) break;
            TeleportHandler.teleportPlayer(player, portal);
            playersInPortal.put(playerId, true);
            break;
        }
        if (!isInAnyPortal) {
            playersInPortal.remove(playerId);
        }
    }

    @Unique
    private boolean isPlayerInPortalArea(class_2338 playerPos, PortalData.PositionGroup positions) {
        double minX = Math.min(positions.pos1.x, positions.pos2.x);
        double maxX = Math.max(positions.pos1.x, positions.pos2.x);
        double minY = Math.min(positions.pos1.y, positions.pos2.y);
        double maxY = Math.max(positions.pos1.y, positions.pos2.y);
        double minZ = Math.min(positions.pos1.z, positions.pos2.z);
        double maxZ = Math.max(positions.pos1.z, positions.pos2.z);
        return (double)playerPos.method_10263() >= minX && (double)playerPos.method_10263() <= maxX && (double)playerPos.method_10264() >= minY && (double)playerPos.method_10264() <= maxY && (double)playerPos.method_10260() >= minZ && (double)playerPos.method_10260() <= maxZ;
    }
}

