/*
 * Decompiled with CFR 0.152.
 */
package tw.iehow;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import tw.iehow.ProxyPortal;
import tw.iehow.data.PortalData;
import tw.iehow.data.PortalManager;

public class PortalCommand {
    private static final String PORTAL_CREATE_SUCCESS = "\u00a7aSuccessfully created portal: %s";
    private static final String PORTAL_CREATE_FAILED = "\u00a7cFailed to create portal: %s";
    private static final String PORTAL_CREATE_ERROR = "\u00a7cError occurred while creating portal: %s";
    private static final String PORTAL_DELETE_SUCCESS = "\u00a7aSuccessfully deleted portal: %s";
    private static final String PORTAL_DELETE_NOTFOUND = "\u00a7cPortal not found: %s";
    private static final String PORTAL_DELETE_ERROR = "\u00a7cError occurred while deleting portal: %s";
    private static final String PORTAL_LIST_EMPTY = "\u00a7eNo portals currently exist";
    private static final String PORTAL_LIST_HEADER = "\u00a7aPortal List:";
    private static final String PORTAL_LIST_ITEM = "\u00a7b- %s";
    private static final String PORTAL_LIST_DIMENSION = "  \u00a77Dimension: %s";
    private static final String PORTAL_LIST_COORDINATES = "  \u00a77Coordinates: (%.1f, %.1f, %.1f) to (%.1f, %.1f, %.1f)";
    private static final String PORTAL_LIST_TARGET_SERVER = "  \u00a77Target Server: %s";
    private static final String PORTAL_LIST_ERROR = "\u00a7cError occurred while listing portals: %s";
    private static final String PORTAL_RELOAD_SUCCESS = "\u00a7aSuccessfully reloaded portal data";
    private static final String PORTAL_RELOAD_ERROR = "\u00a7cError occurred while reloading portals: %s";
    private static final SuggestionProvider<class_2168> PORTAL_NAME_SUGGESTIONS = (context, builder) -> {
        List<PortalData> portals = PortalManager.getAllPortals();
        for (PortalData portal : portals) {
            builder.suggest(portal.portalName);
        }
        return builder.buildFuture();
    };

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"portal").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"x1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z1", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"x2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"y2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"z2", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"server", (ArgumentType)StringArgumentType.string()).executes(PortalCommand::createPortal))))))))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(PORTAL_NAME_SUGGESTIONS).executes(PortalCommand::deletePortal)))).then(class_2170.method_9247((String)"list").executes(PortalCommand::listPortals))).then(class_2170.method_9247((String)"reload").executes(PortalCommand::reloadPortals))));
    }

    private static int createPortal(CommandContext<class_2168> context) {
        try {
            String name = StringArgumentType.getString(context, (String)"name");
            double x1 = DoubleArgumentType.getDouble(context, (String)"x1");
            double y1 = DoubleArgumentType.getDouble(context, (String)"y1");
            double z1 = DoubleArgumentType.getDouble(context, (String)"z1");
            double x2 = DoubleArgumentType.getDouble(context, (String)"x2");
            double y2 = DoubleArgumentType.getDouble(context, (String)"y2");
            double z2 = DoubleArgumentType.getDouble(context, (String)"z2");
            String server = StringArgumentType.getString(context, (String)"server");
            class_2168 source = (class_2168)context.getSource();
            String dimension = source.method_9225().method_27983().method_29177().toString();
            PortalData.Position pos1 = new PortalData.Position(x1, y1, z1);
            PortalData.Position pos2 = new PortalData.Position(x2, y2, z2);
            PortalData.PositionGroup positions = new PortalData.PositionGroup(dimension, pos1, pos2);
            PortalData portalData = new PortalData(name, positions, server);
            boolean success = PortalManager.createPortal(portalData);
            if (success) {
                source.method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_CREATE_SUCCESS, name)), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_CREATE_FAILED, name)), false);
            }
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_CREATE_ERROR, e.getMessage())), false);
            ProxyPortal.LOGGER.error("Failed to create portal", (Throwable)e);
        }
        return 1;
    }

    private static int deletePortal(CommandContext<class_2168> context) {
        try {
            String name = StringArgumentType.getString(context, (String)"name");
            boolean success = PortalManager.deletePortal(name);
            if (success) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_DELETE_SUCCESS, name)), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_DELETE_NOTFOUND, name)), false);
            }
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_DELETE_ERROR, e.getMessage())), false);
            ProxyPortal.LOGGER.error("Failed to delete portal", (Throwable)e);
        }
        return 1;
    }

    private static int listPortals(CommandContext<class_2168> context) {
        try {
            List<PortalData> portals = PortalManager.getAllPortals();
            if (portals.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)PORTAL_LIST_EMPTY), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)PORTAL_LIST_HEADER), false);
                for (PortalData portal : portals) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_LIST_ITEM, portal.portalName)), false);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_LIST_DIMENSION, portal.positions.dimension)), false);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_LIST_COORDINATES, portal.positions.pos1.x, portal.positions.pos1.y, portal.positions.pos1.z, portal.positions.pos2.x, portal.positions.pos2.y, portal.positions.pos2.z)), false);
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_LIST_TARGET_SERVER, portal.destinationServer)), false);
                }
            }
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_LIST_ERROR, e.getMessage())), false);
            ProxyPortal.LOGGER.error("Failed to list portals", (Throwable)e);
        }
        return 1;
    }

    private static int reloadPortals(CommandContext<class_2168> context) {
        try {
            PortalManager.reloadPortals();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)PORTAL_RELOAD_SUCCESS), false);
            ProxyPortal.LOGGER.info("Reloaded portal data");
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format(PORTAL_RELOAD_ERROR, e.getMessage())), false);
            ProxyPortal.LOGGER.error("Failed to reload portals", (Throwable)e);
        }
        return 1;
    }
}

