/*
 * Decompiled with CFR 0.152.
 */
package tw.iehow.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tw.iehow.ProxyPortal;
import tw.iehow.data.PortalData;

public class PortalManager {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String DATA_FOLDER = "config";
    private static final String PORTALS_DATA_FILE = "proxyportal_data.json";
    private static final Map<String, PortalData> portals = new HashMap<String, PortalData>();

    public static boolean createPortal(PortalData portalData) {
        try {
            if (portals.containsKey(portalData.portalName)) {
                return false;
            }
            portals.put(portalData.portalName, portalData);
            PortalManager.savePortals();
            return true;
        }
        catch (Exception e) {
            ProxyPortal.LOGGER.error("Failed to create portal: {}", (Object)portalData.portalName, (Object)e);
            return false;
        }
    }

    public static boolean deletePortal(String portalName) {
        try {
            if (!portals.containsKey(portalName)) {
                return false;
            }
            portals.remove(portalName);
            PortalManager.savePortals();
            return true;
        }
        catch (Exception e) {
            ProxyPortal.LOGGER.error("Failed to delete portal: {}", (Object)portalName, (Object)e);
            return false;
        }
    }

    public static List<PortalData> getAllPortals() {
        return new ArrayList<PortalData>(portals.values());
    }

    public static void reloadPortals() throws IOException {
        portals.clear();
        PortalManager.loadPortals();
    }

    public static void initializePortals() {
        try {
            PortalManager.loadPortals();
        }
        catch (Exception e) {
            ProxyPortal.LOGGER.error("Failed to initialize portals", (Throwable)e);
        }
    }

    private static void savePortals() throws IOException {
        Path dataPath = Paths.get(DATA_FOLDER, new String[0]);
        if (!Files.exists(dataPath, new LinkOption[0])) {
            Files.createDirectories(dataPath, new FileAttribute[0]);
        }
        File file = new File(DATA_FOLDER, PORTALS_DATA_FILE);
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(portals, (Appendable)writer);
        }
    }

    private static void loadPortals() throws IOException {
        File file = new File(DATA_FOLDER, PORTALS_DATA_FILE);
        if (!file.exists()) {
            ProxyPortal.LOGGER.info("Portal data file not found. Creating default configuration with example portals.");
            PortalManager.createDefaultPortalConfig();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Type type = new TypeToken<Map<String, PortalData>>(){}.getType();
            Map loadedPortals = (Map)gson.fromJson((Reader)reader, type);
            if (loadedPortals != null) {
                portals.putAll(loadedPortals);
            }
        }
    }

    private static void createDefaultPortalConfig() throws IOException {
        PortalData examplePortal = new PortalData("example_portal", new PortalData.PositionGroup("example:dimension", new PortalData.Position(0.0, 64.0, 0.0), new PortalData.Position(5.0, 70.0, 5.0)), "lobby");
        portals.put(examplePortal.portalName, examplePortal);
        PortalManager.savePortals();
    }

    public static int getPortalCount() {
        return portals.size();
    }
}

