/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spellchecker.config;

import com.mrbysco.spellchecker.Constants;
import com.mrbysco.spellchecker.language.LanguageEnum;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SpellCheckerConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded SpellChecker's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.warn("SpellChecker's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.EnumValue<LanguageEnum> language_to_check;
        public final ModConfigSpec.IntValue checking_threshold;
        public final ModConfigSpec.IntValue max_suggestions;
        public final ModConfigSpec.BooleanValue show_suggestions_live;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("LanguageEnum settings").push("language");
            this.language_to_check = builder.comment("LanguageEnum locale the mod uses to check your chat messages. [default: EN_US]").defineEnum("language_to_check", (Enum)LanguageEnum.EN_US);
            builder.pop();
            builder.comment("Checking settings").push("checking");
            this.checking_threshold = builder.comment("The threshold the mod uses to check how close a word needs to be to the wrongly spelled word. [default: 0]").defineInRange("checking_threshold", 0, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("General settings").push("general");
            this.max_suggestions = builder.comment("The maximum number of suggestions it will show you. [default: 4]").defineInRange("max_suggestions", 4, 1, 20);
            this.show_suggestions_live = builder.comment("Show suggestions live while typing. [default: false]").define("show_suggestions_live", false);
            builder.pop();
        }
    }
}

