/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spellchecker.util;

import com.mrbysco.spellchecker.CommonClass;
import com.mrbysco.spellchecker.Constants;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class DictionaryUtil {
    public static File personalFolder;
    public static File personalDictionary;

    public static void AddToPersonal(String word) {
        try {
            if (personalDictionary.exists()) {
                FileWriter fileWriter = new FileWriter(personalDictionary, true);
                if (!DictionaryUtil.containsWordAlready(word.toLowerCase())) {
                    fileWriter.write(word.toLowerCase());
                    fileWriter.write("\n");
                }
                fileWriter.close();
            } else {
                FileWriter fileWriter = new FileWriter(personalDictionary);
                fileWriter.write(word.toLowerCase());
                fileWriter.write("\n");
                fileWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean containsWordAlready(String word) throws FileNotFoundException {
        boolean found = false;
        try {
            Scanner scanner = new Scanner(personalDictionary);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().toLowerCase();
                if (!line.equals(word)) continue;
                scanner.close();
                return true;
            }
            scanner.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return found;
    }

    public static InputStream getDictionaryWords(String locale_name) throws IOException {
        if (!locale_name.isEmpty()) {
            try {
                return ((Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)"spellchecker", (String)("dictionaries/" + locale_name + "/dictionary.txt"))).get()).open();
            }
            catch (IOException e) {
                Constants.LOGGER.error("Invalid locale {}", (Object)locale_name);
                Constants.LOGGER.trace("Exception: ", (Throwable)e);
                return null;
            }
        }
        return ((Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)"spellchecker", (String)"dictionaries/en_us/dictionary.txt")).get()).open();
    }

    public static void buildLanguageMap(String locale) {
        try {
            InputStream dictionary = DictionaryUtil.getDictionaryWords(locale);
            BufferedReader dictReader = null;
            if (dictionary != null) {
                dictReader = new BufferedReader(new InputStreamReader(dictionary, Charset.forName("UTF-8")));
            }
            CommonClass.setDict((SpellDictionary)new SpellDictionaryHashMap());
            if (dictReader != null) {
                String line;
                while ((line = dictReader.readLine()) != null) {
                    CommonClass.getDict().addWord(line);
                }
                dictReader.close();
                dictReader = null;
                Object var2_1 = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addPersonalToLanguageMap() {
        try {
            if (personalDictionary != null && personalDictionary.exists()) {
                Scanner scanner = new Scanner(personalDictionary);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().toLowerCase();
                    if (line.isEmpty() || CommonClass.getDict().isCorrect(line)) continue;
                    CommonClass.getDict().addWord(line);
                }
                scanner.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

