/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spellchecker.util;

import com.mrbysco.spellchecker.mixin.ChatScreenAccessor;
import com.mrbysco.spellchecker.mixin.EditBoxAccessor;
import com.mrbysco.spellchecker.platform.Services;
import com.mrbysco.spellchecker.util.LocationData;
import com.mrbysco.spellchecker.util.SuggestionInfo;
import com.mrbysco.spellchecker.util.SuggestionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class SuggestionRendering {
    public static void renderSuggestions(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, ChatScreen chat) {
        List<String> suggestions;
        Font font = Minecraft.getInstance().font;
        if (!SuggestionUtil.keptSuggestions.isEmpty()) {
            for (SuggestionInfo info : SuggestionUtil.keptSuggestions) {
                int posX = info.posX();
                int posY = info.posY();
                suggestions = info.suggestions();
                SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, posX, posY);
            }
        }
        if (!(SuggestionUtil.wronglySpelledWords.isEmpty() || SuggestionUtil.wordSuggestions.isEmpty() || SuggestionUtil.wordPosition.isEmpty())) {
            boolean showSuggestionsLive = Services.PLATFORM.showSuggestionsLive();
            for (int i = 0; i < SuggestionUtil.wronglySpelledWords.size(); ++i) {
                boolean isLastWord = i == SuggestionUtil.wronglySpelledWords.size() - 1;
                String word = SuggestionUtil.wronglySpelledWords.get(i);
                suggestions = SuggestionUtil.wordSuggestions.get(word);
                EditBox editBox = ((ChatScreenAccessor)chat).spellchecker_getEditbox();
                int lineScrollOffset = ((EditBoxAccessor)editBox).spellchecker_getDisplayPos();
                String chatText = editBox.getValue();
                if (chatText.length() <= lineScrollOffset) continue;
                String currentlyDisplayedText = chatText.substring(lineScrollOffset);
                for (LocationData data : SuggestionUtil.wordPosition) {
                    String firstWord;
                    String originalWord = data.word();
                    String wordUntilTypo = data.wordsUntil();
                    if (!originalWord.equals(word)) continue;
                    if (currentlyDisplayedText.contains(wordUntilTypo)) {
                        int width = font.width(wordUntilTypo);
                        StringBuilder wrongSquigly = new StringBuilder();
                        wrongSquigly.append("~".repeat(word.length()));
                        if (font.width(word) <= font.width(wrongSquigly.toString())) {
                            int left = font.width(wrongSquigly.toString()) - font.width(word);
                            int removeCount = (int)Math.floor((double)left / (double)font.width("~"));
                            wrongSquigly = new StringBuilder(wrongSquigly.substring(removeCount));
                        }
                        if (font.width(word) <= font.width(wrongSquigly.toString())) {
                            wrongSquigly = new StringBuilder(wrongSquigly.substring(1));
                        }
                        if (font.width(wrongSquigly.toString()) == 0 && font.width(word) > 0) {
                            wrongSquigly = new StringBuilder("~");
                        }
                        guiGraphics.drawString(font, wrongSquigly.toString(), width + 4, chat.height - 4, ARGB.opaque((int)0xFF5555), false);
                        int n = chat.height - 12;
                        int n2 = font.width(word);
                        Objects.requireNonNull(font);
                        boolean hoveredFlag = SuggestionUtil.hoverBoolean(mouseX, mouseY, 2 + width, n, n2, 9);
                        if (!hoveredFlag && (!showSuggestionsLive || !isLastWord)) continue;
                        SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, width - 6, chat.height - (6 + ((ArrayList)suggestions).size() * 12));
                        continue;
                    }
                    String[] Words = currentlyDisplayedText.split(" ");
                    if (Words.length <= 0 || (firstWord = Words[0]).isEmpty() || !word.contains(firstWord)) continue;
                    int width = font.width(firstWord);
                    StringBuilder wrongSquigly = new StringBuilder();
                    wrongSquigly.append("~".repeat(firstWord.length()));
                    if (font.width(word) <= font.width(wrongSquigly.toString())) {
                        int left = font.width(wrongSquigly.toString()) - font.width(word);
                        int removeCount = (int)Math.floor((double)left / (double)font.width("~"));
                        wrongSquigly = new StringBuilder(wrongSquigly.substring(removeCount));
                    }
                    if (font.width(word) <= font.width(wrongSquigly.toString())) {
                        wrongSquigly = new StringBuilder(wrongSquigly.substring(1));
                    }
                    if (font.width(wrongSquigly.toString()) == 0 && font.width(word) > 0) {
                        wrongSquigly = new StringBuilder("~");
                    }
                    guiGraphics.drawString(font, wrongSquigly.toString(), width + 2, chat.height - 4, ARGB.opaque((int)0xFF5555), false);
                    int n = chat.height - 12;
                    int n3 = font.width(word);
                    Objects.requireNonNull(font);
                    boolean hoveredFlag = SuggestionUtil.hoverBoolean(mouseX, mouseY, 2 + width, n, n3, 9);
                    if (!hoveredFlag) continue;
                    SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, width - 6, chat.height - (6 + ((ArrayList)suggestions).size() * 12));
                }
            }
        }
    }

    public static void drawInfoTooltip(GuiGraphics guiGraphics, Font font, List<String> textLines, int x, int y) {
        guiGraphics.setTooltipForNextFrame(font, textLines.stream().map(text -> Component.literal((String)text).getVisualOrderText()).collect(Collectors.toList()), x, y);
    }
}

