/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spellchecker.util;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mrbysco.spellchecker.CommonClass;
import com.mrbysco.spellchecker.mixin.ChatScreenAccessor;
import com.mrbysco.spellchecker.mixin.EditBoxAccessor;
import com.mrbysco.spellchecker.mixin.GameRendererAccessor;
import com.mrbysco.spellchecker.platform.Services;
import com.mrbysco.spellchecker.util.DictionaryUtil;
import com.mrbysco.spellchecker.util.LocationData;
import com.mrbysco.spellchecker.util.SuggestionInfo;
import com.mrbysco.spellchecker.util.SuggestionRendering;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.Word;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class SuggestionUtil {
    public static final HashMap<String, ArrayList<String>> wordSuggestions = new LinkedHashMap<String, ArrayList<String>>();
    public static final List<LocationData> wordPosition = new LinkedList<LocationData>();
    public static final List<String> wronglySpelledWords = new LinkedList<String>();
    public static final List<SuggestionInfo> keptSuggestions = new LinkedList<SuggestionInfo>();
    public static String currentLocale;

    public static void onKeyPressed(KeyEvent event, EditBox box) {
        if (SuggestionUtil.isKeyDown(32) || SuggestionUtil.isKeyDown(259) || SuggestionUtil.isKeyDown(265) || SuggestionUtil.isKeyDown(264) || SuggestionUtil.isKeyDown(263) || SuggestionUtil.isKeyDown(262)) {
            SuggestionUtil.refreshSuggestions(box);
        }
        if (SuggestionUtil.isKeyDown(340) && SuggestionUtil.isKeyDown(259)) {
            keptSuggestions.clear();
        }
    }

    public static void onMouseClicked(MouseButtonEvent event, boolean isDoubleClick, ChatScreen chat) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        double mouseX = event.x();
        double mouseY = event.y();
        if (!(wronglySpelledWords == null || wronglySpelledWords.isEmpty() || wordSuggestions == null || wordSuggestions.isEmpty() || wordPosition == null || wordPosition.isEmpty())) {
            GuiGraphics guiGraphics = new GuiGraphics(mc, ((GameRendererAccessor)mc.gameRenderer).spellchecker_getGameRenderState());
            for (String word : wronglySpelledWords) {
                ArrayList<String> suggestions = wordSuggestions.get(word);
                EditBox editBox = ((ChatScreenAccessor)chat).spellchecker_getEditbox();
                int lineScrollOffset = ((EditBoxAccessor)editBox).spellchecker_getDisplayPos();
                String chatText = editBox.getValue();
                if (chatText.length() <= lineScrollOffset) continue;
                String currentlyDisplayedText = chatText.substring(lineScrollOffset);
                for (LocationData data : wordPosition) {
                    String firstWord;
                    String originalWord = data.word();
                    String wordUntilTypo = data.wordsUntil();
                    if (!originalWord.equals(word)) continue;
                    if (currentlyDisplayedText.contains(wordUntilTypo)) {
                        int width = font.width(wordUntilTypo);
                        int n = (int)mouseX;
                        int n2 = (int)mouseY;
                        int n3 = chat.height - 12;
                        int n4 = font.width(word);
                        Objects.requireNonNull(font);
                        boolean hoveredFlag = SuggestionUtil.hoverBoolean(n, n2, 2 + width, n3, n4, 9);
                        if (!hoveredFlag) continue;
                        SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, width - 6, chat.height - (6 + suggestions.size() * 12));
                        SuggestionUtil.addToDictionary(editBox, word);
                        SuggestionUtil.keepSuggestion(editBox, width - 6, chat.height - 12, word, suggestions);
                        continue;
                    }
                    String[] Words = currentlyDisplayedText.split(" ");
                    if (Words.length <= 0 || (firstWord = Words[0]).isEmpty() || !word.contains(firstWord)) continue;
                    int width = font.width(firstWord);
                    int n = (int)mouseX;
                    int n5 = (int)mouseY;
                    int n6 = chat.height - 12;
                    int n7 = font.width(word);
                    Objects.requireNonNull(font);
                    boolean hoveredFlag = SuggestionUtil.hoverBoolean(n, n5, 2 + width, n6, n7, 9);
                    if (!hoveredFlag) continue;
                    SuggestionRendering.drawInfoTooltip(guiGraphics, font, suggestions, width - 6, chat.height - (6 + suggestions.size() * 12));
                    SuggestionUtil.addToDictionary(editBox, word);
                    SuggestionUtil.keepSuggestion(editBox, width - 6, chat.height - 20, word, suggestions);
                }
            }
        }
    }

    protected static boolean hoverBoolean(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    private static boolean isKeyDown(int keyCode) {
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)keyCode);
    }

    public static void addToDictionary(EditBox box, String word) {
        if (SuggestionUtil.isKeyDown(341)) {
            try {
                if (DictionaryUtil.personalDictionary == null) {
                    DictionaryUtil.personalDictionary = new File(DictionaryUtil.personalFolder, "/dictionary.txt");
                }
                DictionaryUtil.AddToPersonal(word);
                SuggestionUtil.refreshSuggestions(box);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void keepSuggestion(EditBox box, int x, int y, String word, ArrayList<String> suggestions) {
        SuggestionInfo sInfo;
        if (SuggestionUtil.isKeyDown(340) && keptSuggestions != null && !keptSuggestions.contains(sInfo = new SuggestionInfo(x, y, suggestions, word))) {
            keptSuggestions.add(sInfo);
        }
    }

    public static void refreshSuggestions(EditBox editBox) {
        DictionaryUtil.addPersonalToLanguageMap();
        wordSuggestions.clear();
        wordPosition.clear();
        wronglySpelledWords.clear();
        String chatText = editBox.getValue();
        int lineScrollOffset = ((EditBoxAccessor)editBox).spellchecker_getDisplayPos();
        String visibleString = chatText.substring(lineScrollOffset);
        String[] CurrentWords = visibleString.split(" ");
        if (CurrentWords.length > 0) {
            for (int i = 0; i < CurrentWords.length; ++i) {
                String extraStripped;
                SpellDictionary dict;
                String wordToCheck = CurrentWords[i];
                String strippedWord = wordToCheck;
                if (strippedWord.isEmpty() || (dict = CommonClass.getDict()).isCorrect(strippedWord) || (strippedWord = (extraStripped = SuggestionUtil.stripWord(currentLocale, strippedWord))).isEmpty() || dict.isCorrect(strippedWord)) continue;
                StringBuilder tillEndOfWord = new StringBuilder();
                for (int j = 0; j <= i; ++j) {
                    if (j == i) continue;
                    tillEndOfWord.append(CurrentWords[j]);
                    tillEndOfWord.append(" ");
                }
                ArrayList<String> suggestions = SuggestionUtil.getSuggestions(strippedWord);
                LocationData locData = new LocationData(wordToCheck, tillEndOfWord.toString());
                wordSuggestions.put(wordToCheck, suggestions);
                wronglySpelledWords.add(wordToCheck);
                wordPosition.add(locData);
            }
        }
    }

    public static ArrayList<String> getSuggestions(String misspelledWord) {
        int threshold = Services.PLATFORM.getCheckingThreshold();
        int maxSuggestions = Services.PLATFORM.getMaxSuggestions();
        List words = new ArrayList();
        if (!misspelledWord.isEmpty()) {
            words = CommonClass.getDict().getSuggestions(misspelledWord, threshold);
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!words.isEmpty()) {
            for (Word suggestion : words) {
                if (suggestions.size() > maxSuggestions) continue;
                suggestions.add(suggestion.getWord());
            }
        }
        return suggestions;
    }

    public static String stripWord(String locale, String word) {
        String strippedWord = word;
        if (!word.isEmpty()) {
            if (locale != null && locale.equals("nl_nl")) {
                strippedWord = strippedWord.replace("'s", "");
                strippedWord = strippedWord.replace("'tje", "");
            }
            strippedWord = strippedWord.replaceAll("[^\\p{IsAlphabetic}\\d]", "");
        }
        return strippedWord;
    }
}

