/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RealApolloPrefetch
implements ApolloPrefetch {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final ScalarTypeAdapters scalarTypeAdapters;
    final Executor dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final ApolloInterceptorChain interceptorChain;
    final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    final AtomicReference<ApolloPrefetch.Callback> originalCallback = new AtomicReference();

    public RealApolloPrefetch(Operation operation, HttpUrl serverUrl, Call.Factory httpCallFactory, ScalarTypeAdapters scalarTypeAdapters, Executor dispatcher, ApolloLogger logger, ApolloCallTracker callTracker) {
        this.operation = operation;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.tracker = callTracker;
        this.interceptorChain = new RealApolloInterceptorChain(Collections.singletonList(new ApolloServerInterceptor(serverUrl, httpCallFactory, HttpCachePolicy.NETWORK_ONLY, true, scalarTypeAdapters, logger)));
    }

    @Override
    public void enqueue(@Nullable ApolloPrefetch.Callback responseCallback) {
        try {
            this.activate(Optional.fromNullable(responseCallback));
        }
        catch (ApolloCanceledException e) {
            if (responseCallback != null) {
                responseCallback.onFailure(e);
            } else {
                this.logger.e(e, "Operation: %s was canceled", this.operation().name().name());
            }
            return;
        }
        ApolloInterceptor.InterceptorRequest request = ApolloInterceptor.InterceptorRequest.builder(this.operation).build();
        this.interceptorChain.proceedAsync(request, this.dispatcher, this.interceptorCallbackProxy());
    }

    @Override
    @NotNull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy() {
        return new ApolloInterceptor.CallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                try (Response httpResponse = response.httpResponse.get();){
                    Optional<ApolloPrefetch.Callback> callback = RealApolloPrefetch.this.terminate();
                    if (!callback.isPresent()) {
                        RealApolloPrefetch.this.logger.d("onResponse for prefetch operation: %s. No callback present.", RealApolloPrefetch.this.operation().name().name());
                        return;
                    }
                    if (httpResponse.isSuccessful()) {
                        callback.get().onSuccess();
                    } else {
                        callback.get().onHttpError(new ApolloHttpException(httpResponse));
                    }
                }
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                Optional<ApolloPrefetch.Callback> callback = RealApolloPrefetch.this.terminate();
                if (!callback.isPresent()) {
                    RealApolloPrefetch.this.logger.e(e, "onFailure for prefetch operation: %s. No callback present.", RealApolloPrefetch.this.operation().name().name());
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.get().onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.get().onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.get().onFailure(e);
                }
            }

            @Override
            public void onCompleted() {
            }

            @Override
            public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
            }
        };
    }

    @Override
    public ApolloPrefetch clone() {
        return new RealApolloPrefetch(this.operation, this.serverUrl, this.httpCallFactory, this.scalarTypeAdapters, this.dispatcher, this.logger, this.tracker);
    }

    @Override
    public synchronized void cancel() {
        switch (this.state.get()) {
            case ACTIVE: {
                try {
                    this.interceptorChain.dispose();
                    break;
                }
                finally {
                    this.tracker.unregisterPrefetchCall(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case IDLE: {
                this.state.set(CallState.CANCELED);
                break;
            }
            case CANCELED: 
            case TERMINATED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    private synchronized void activate(Optional<ApolloPrefetch.Callback> callback) throws ApolloCanceledException {
        switch (this.state.get()) {
            case IDLE: {
                this.originalCallback.set(callback.orNull());
                this.tracker.registerPrefetchCall(this);
                break;
            }
            case CANCELED: {
                throw new ApolloCanceledException();
            }
            case ACTIVE: 
            case TERMINATED: {
                throw new IllegalStateException("Already Executed");
            }
            default: {
                throw new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    synchronized Optional<ApolloPrefetch.Callback> terminate() {
        switch (this.state.get()) {
            case ACTIVE: {
                this.tracker.unregisterPrefetchCall(this);
                this.state.set(CallState.TERMINATED);
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case CANCELED: {
                return Optional.fromNullable(this.originalCallback.getAndSet(null));
            }
            case IDLE: 
            case TERMINATED: {
                throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
            }
        }
        throw new IllegalStateException("Unknown state");
    }
}

