/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.api.IStorageBackend;
import com.github.philippheuer.credentialmanager.authcontroller.DummyAuthController;
import com.github.philippheuer.credentialmanager.domain.AuthenticationController;
import com.github.philippheuer.credentialmanager.storage.TemporaryStorageBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialManagerBuilder {
    private static final Logger log = LoggerFactory.getLogger(CredentialManagerBuilder.class);
    private IStorageBackend storageBackend = new TemporaryStorageBackend();
    private AuthenticationController authenticationController = new DummyAuthController();

    public static CredentialManagerBuilder builder() {
        return new CredentialManagerBuilder();
    }

    public CredentialManager build() {
        CredentialManager credentialManager = new CredentialManager(this.storageBackend, this.authenticationController);
        return credentialManager;
    }

    private CredentialManagerBuilder() {
    }

    private CredentialManagerBuilder(IStorageBackend storageBackend, AuthenticationController authenticationController) {
        this.storageBackend = storageBackend;
        this.authenticationController = authenticationController;
    }

    public CredentialManagerBuilder withStorageBackend(IStorageBackend storageBackend) {
        return this.storageBackend == storageBackend ? this : new CredentialManagerBuilder(storageBackend, this.authenticationController);
    }

    public CredentialManagerBuilder withAuthenticationController(AuthenticationController authenticationController) {
        return this.authenticationController == authenticationController ? this : new CredentialManagerBuilder(this.storageBackend, authenticationController);
    }
}

