/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.domain;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DeviceFlowError {
    AUTHORIZATION_PENDING,
    SLOW_DOWN,
    ACCESS_DENIED,
    EXPIRED_TOKEN,
    INVALID_REQUEST,
    INVALID_CLIENT,
    INVALID_GRANT,
    UNAUTHORIZED_CLIENT,
    UNSUPPORTED_GRANT_TYPE,
    UNKNOWN;

    private static final Map<String, DeviceFlowError> MAPPINGS;

    public boolean shouldRetry() {
        return this == AUTHORIZATION_PENDING || this == SLOW_DOWN;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static DeviceFlowError from(String code) {
        return MAPPINGS.getOrDefault(code, UNKNOWN);
    }

    static {
        MAPPINGS = Arrays.stream(DeviceFlowError.values()).collect(Collectors.toMap(Enum::toString, Function.identity()));
    }
}

