/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.smlib.server.spigot;

import com.morelaid.shared.StreamerJsonCodec;
import com.morelaid.shared.StreamerLiveTag;
import com.morelaid.smlib.server.spigot.functions.SpigotHandler;
import com.morelaid.smlib.server.spigot.placeholderapi.SMLibPlaceholder;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class SMLibSpigot
extends JavaPlugin
implements PluginMessageListener {
    final String CHANNEL = "smlib:livetag";
    private SpigotHandler handler;

    public void onEnable() {
        this.handler = new SpigotHandler(this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "smlib:livetag", (PluginMessageListener)this);
        this.enableExternalAPI();
        this.getLogger().info("SMlib loaded!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!"smlib:livetag".equalsIgnoreCase(channel)) {
            return;
        }
        try {
            HashMap<String, StreamerLiveTag> incoming = StreamerJsonCodec.decodeMap(message);
            HashMap<String, StreamerLiveTag> hashMap = this.handler.getStreamerMap();
            synchronized (hashMap) {
                this.handler.getStreamerMap().clear();
                this.handler.getStreamerMap().putAll(incoming);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("StreamerSync decode error: " + e.getMessage());
        }
    }

    public void enableExternalAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new SMLibPlaceholder(this.handler).register();
        }
    }
}

