/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.jdbc;

import com.morelaid.streamingmodule.external.j256.ormlite.db.DatabaseType;
import com.morelaid.streamingmodule.external.j256.ormlite.jdbc.db.DatabaseTypeUtils;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.Logger;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LoggerFactory;
import com.morelaid.streamingmodule.external.j256.ormlite.misc.IOUtils;
import com.morelaid.streamingmodule.external.j256.ormlite.support.BaseConnectionSource;
import com.morelaid.streamingmodule.external.j256.ormlite.support.ConnectionSource;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnection;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnectionProxyFactory;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class BaseJdbcConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    protected static Logger logger = LoggerFactory.getLogger(BaseJdbcConnectionSource.class);
    protected String url;
    protected DatabaseConnection connection;
    protected DatabaseType databaseType;
    protected boolean initialized = false;
    private static DatabaseConnectionProxyFactory connectionProxyFactory;

    public BaseJdbcConnectionSource() {
    }

    public BaseJdbcConnectionSource(String url) throws SQLException {
        this(url, null, true);
    }

    public BaseJdbcConnectionSource(String url, DatabaseType databaseType) throws SQLException {
        this(url, databaseType, true);
    }

    protected BaseJdbcConnectionSource(String url, DatabaseType databaseType, boolean initialize) throws SQLException {
        this.url = url;
        this.databaseType = databaseType;
        if (initialize) {
            this.initialize();
        }
    }

    protected abstract DatabaseConnection makeConnection(Logger var1) throws SQLException;

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.url == null) {
            throw new SQLException("url was never set on " + this.getClass().getSimpleName());
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseTypeUtils.createDatabaseType(this.url);
        }
        this.databaseType.loadDriver();
        this.databaseType.setDriver(DriverManager.getDriver(this.url));
        this.initialized = true;
    }

    @Override
    public void close() throws Exception {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            this.connection.close();
            logger.debug("closed connection #{}", this.connection.hashCode());
            this.connection = null;
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public DatabaseConnection getReadOnlyConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.getReadWriteConnection(tableName);
    }

    @Override
    public DatabaseConnection getReadWriteConnection(String tableName) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                throw new SQLException("Connection has already been closed");
            }
            return this.connection;
        }
        this.connection = this.makeConnection(logger);
        if (connectionProxyFactory != null) {
            this.connection = connectionProxyFactory.createProxy(this.connection);
        }
        return this.connection;
    }

    @Override
    public void releaseConnection(DatabaseConnection connection) throws SQLException {
        if (!this.initialized) {
            throw new SQLException(this.getClass().getSimpleName() + " was not initialized properly");
        }
    }

    @Override
    public boolean saveSpecialConnection(DatabaseConnection connection) throws SQLException {
        return true;
    }

    @Override
    public void clearSpecialConnection(DatabaseConnection connection) {
    }

    @Override
    public DatabaseType getDatabaseType() {
        if (!this.initialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was not initialized properly");
        }
        return this.databaseType;
    }

    @Override
    public boolean isOpen(String tableName) {
        return this.connection != null;
    }

    @Override
    public boolean isSingleConnection(String tableName) {
        return true;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public static void setDatabaseConnectionProxyFactory(DatabaseConnectionProxyFactory connectionProxyFactory) {
        BaseJdbcConnectionSource.connectionProxyFactory = connectionProxyFactory;
    }
}

