/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.logger;

import com.morelaid.streamingmodule.external.j256.ormlite.logger.Level;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LogBackend;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LogBackendFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsLoggingLogBackend
implements LogBackend {
    private final Log log;

    public CommonsLoggingLogBackend(String className) {
        this.log = LogFactory.getLog(className);
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.log.isTraceEnabled();
            }
            case DEBUG: {
                return this.log.isDebugEnabled();
            }
            case WARNING: {
                return this.log.isWarnEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
            case FATAL: {
                return this.log.isFatalEnabled();
            }
        }
        return this.log.isInfoEnabled();
    }

    @Override
    public void log(Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.log.trace(msg);
                break;
            }
            case DEBUG: {
                this.log.debug(msg);
                break;
            }
            case WARNING: {
                this.log.warn(msg);
                break;
            }
            case ERROR: {
                this.log.error(msg);
                break;
            }
            case FATAL: {
                this.log.fatal(msg);
                break;
            }
            default: {
                this.log.info(msg);
            }
        }
    }

    @Override
    public void log(Level level, String msg, Throwable t2) {
        switch (level) {
            case TRACE: {
                this.log.trace(msg, t2);
                break;
            }
            case DEBUG: {
                this.log.debug(msg, t2);
                break;
            }
            case WARNING: {
                this.log.warn(msg, t2);
                break;
            }
            case ERROR: {
                this.log.error(msg, t2);
                break;
            }
            case FATAL: {
                this.log.fatal(msg, t2);
                break;
            }
            default: {
                this.log.info(msg, t2);
            }
        }
    }

    public static class CommonsLoggingLogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new CommonsLoggingLogBackend(classLabel);
        }
    }
}

