/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.logger;

import com.morelaid.streamingmodule.external.j256.ormlite.logger.ConsoleLogBackend;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.Level;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LocalLogBackend;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LogBackend;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.LogBackendFactory;
import com.morelaid.streamingmodule.external.j256.ormlite.logger.NullLogBackend;

public enum LogBackendType implements LogBackendFactory
{
    SLF4J("com.morelaid.streamingmodule.external.j256.ormlite.logger.Slf4jLoggingLogBackend$Slf4jLoggingLogBackendFactory"),
    ANDROID("com.morelaid.streamingmodule.external.j256.ormlite.android.AndroidLogBackend$AndroidLogBackendFactory"),
    LOGBACK("com.morelaid.streamingmodule.external.j256.ormlite.logger.LogbackLogBackend$LogbackLogBackendFactory"),
    COMMONS_LOGGING("com.morelaid.streamingmodule.external.j256.ormlite.logger.CommonsLoggingLogBackend$CommonsLoggingLogBackendFactory"),
    LOG4J2("com.morelaid.streamingmodule.external.j256.ormlite.logger.Log4j2LogBackend$Log4j2LogBackendFactory"),
    LOG4J("com.morelaid.streamingmodule.external.j256.ormlite.logger.Log4jLogBackend$Log4jLogBackendFactory"),
    LOCAL(new LocalLogBackend.LocalLogBackendFactory()),
    CONSOLE(new ConsoleLogBackend.ConsoleLogBackendFactory()),
    JAVA_UTIL("com.morelaid.streamingmodule.external.j256.ormlite.logger.JavaUtilLogBackend$JavaUtilLogBackendFactory"),
    NULL(new NullLogBackend.NullLogBackendFactory());

    private final LogBackendFactory factory;

    private LogBackendType(LogBackendFactory factory2) {
        this.factory = factory2;
    }

    private LogBackendType(String logBackendFactoryClassName) {
        this.factory = this.detectFactory(logBackendFactoryClassName);
    }

    @Override
    public LogBackend createLogBackend(String classLabel) {
        return this.factory.createLogBackend(classLabel);
    }

    public boolean isAvailable() {
        return this == LOCAL || this != NULL && !(this.factory instanceof LocalLogBackend.LocalLogBackendFactory);
    }

    private LogBackendFactory detectFactory(String factoryClassName) {
        try {
            LogBackendFactory factory2 = (LogBackendFactory)Class.forName(factoryClassName).newInstance();
            factory2.createLogBackend("test").isLevelEnabled(Level.INFO);
            return factory2;
        }
        catch (Throwable th) {
            String queuedWarning = "Unable to create instance of class " + factoryClassName + " for log type " + this + ", using local log: " + th.getMessage();
            return new LocalLogBackend.LocalLogBackendFactory(queuedWarning);
        }
    }
}

