/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped;

import com.morelaid.streamingmodule.external.j256.ormlite.dao.Dao;
import com.morelaid.streamingmodule.external.j256.ormlite.dao.ObjectCache;
import com.morelaid.streamingmodule.external.j256.ormlite.db.DatabaseType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.FieldType;
import com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnection;
import com.morelaid.streamingmodule.external.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

public class MappedDelete<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedDelete(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(dao, tableInfo, statement, argFieldTypes);
    }

    public static <T, ID> MappedDelete<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot delete from " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        MappedDelete.appendTableName(databaseType, sb, "DELETE FROM ", tableInfo);
        MappedDelete.appendWhereFieldEq(databaseType, idField, sb, null);
        return new MappedDelete<T, ID>(dao, tableInfo, sb.toString(), new FieldType[]{idField});
    }

    public int delete(DatabaseConnection databaseConnection, T data, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args2 = this.getFieldObjects(data);
            int rowC = databaseConnection.delete(this.statement, args2, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args2.length, (Object)rowC);
            if (args2.length > 0) {
                logger.trace("delete arguments: {}", (Object)args2);
            }
            if (rowC > 0 && objectCache != null) {
                Object id = this.idField.extractJavaFieldToSqlArgValue(data);
                objectCache.remove(this.clazz, id);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run delete stmt on object " + data + ": " + this.statement, e);
        }
    }

    public int deleteById(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args2 = new Object[]{this.convertIdToFieldObject(id)};
            int rowC = databaseConnection.delete(this.statement, args2, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args2.length, (Object)rowC);
            if (args2.length > 0) {
                logger.trace("delete arguments: {}", (Object)args2);
            }
            if (rowC > 0 && objectCache != null) {
                objectCache.remove(this.clazz, id);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run deleteById stmt on id " + id + ": " + this.statement, e);
        }
    }
}

