/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped;

import com.morelaid.streamingmodule.external.j256.ormlite.dao.Dao;
import com.morelaid.streamingmodule.external.j256.ormlite.dao.ObjectCache;
import com.morelaid.streamingmodule.external.j256.ormlite.db.DatabaseType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.FieldType;
import com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped.BaseMappedQuery;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnection;
import com.morelaid.streamingmodule.external.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

public class MappedQueryForFieldEq<T, ID>
extends BaseMappedQuery<T, ID> {
    private final String label;

    protected MappedQueryForFieldEq(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultsFieldTypes, String label) {
        super(dao, tableInfo, statement, argFieldTypes, resultsFieldTypes);
        this.label = label;
    }

    public T execute(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        Object result;
        if (objectCache != null && (result = objectCache.get(this.clazz, id)) != null) {
            return result;
        }
        Object[] args2 = new Object[]{this.convertIdToFieldObject(id)};
        Object result2 = databaseConnection.queryForOne(this.statement, args2, this.argFieldTypes, this, objectCache);
        if (result2 == null) {
            logger.debug("{} using '{}' and {} args, got no results", (Object)this.label, (Object)this.statement, (Object)args2.length);
        } else {
            if (result2 == DatabaseConnection.MORE_THAN_ONE) {
                logger.error("{} using '{}' and {} args, got >1 results", (Object)this.label, (Object)this.statement, (Object)args2.length);
                this.logArgs(args2);
                throw new SQLException(this.label + " got more than 1 result: " + this.statement);
            }
            logger.debug("{} using '{}' and {} args, got 1 result", (Object)this.label, (Object)this.statement, (Object)args2.length);
        }
        this.logArgs(args2);
        Object castResult = result2;
        return (T)castResult;
    }

    public static <T, ID> MappedQueryForFieldEq<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, FieldType idFieldType) throws SQLException {
        if (idFieldType == null && (idFieldType = tableInfo.getIdField()) == null) {
            throw new SQLException("Cannot query-for-id with " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        String statement = MappedQueryForFieldEq.buildStatement(databaseType, tableInfo, idFieldType);
        return new MappedQueryForFieldEq<T, ID>(dao, tableInfo, statement, new FieldType[]{idFieldType}, tableInfo.getFieldTypes(), "query-for-id");
    }

    protected static <T, ID> String buildStatement(DatabaseType databaseType, TableInfo<T, ID> tableInfo, FieldType idFieldType) {
        StringBuilder sb = new StringBuilder(64);
        MappedQueryForFieldEq.appendTableName(databaseType, sb, "SELECT * FROM ", tableInfo);
        MappedQueryForFieldEq.appendWhereFieldEq(databaseType, idFieldType, sb, null);
        return sb.toString();
    }

    private void logArgs(Object[] args2) {
        if (args2.length > 0) {
            logger.trace("{} arguments: {}", (Object)this.label, (Object)args2);
        }
    }
}

